package com.liquidnet.service.goblin.dto.manage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Map;

@ApiModel(value = "GoblinStoreMgtConfigEditParam", description = "店铺配置编辑入参")
@Data
public class GoblinStoreMgtConfigEditParam implements Serializable {
    private static final long serialVersionUID = -815274264545867695L;
    @ApiModelProperty(position = 10, value = "店铺ID[64]")
    @NotBlank(message = "店铺ID不能为空") @Size(max = 64)
    private String storeId;
    @ApiModelProperty(position = 11, value = "店铺配置集合[Map]", example = "{\"BUSINESS_STATUS\":\"5\",\"ONOFF_CUSTOMER_SEV\":\"ON\",\"ONOFF_SOLD_OUT_SHOW\":\"ON\",\"LIMIT_WARNING_STOCK\":\"5\"}")
    @NotNull(message = "店铺配置不能为空")
    private Map<String, String> confMap;
}
