package com.liquidnet.service.goblin.param;

import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

@ApiModel(value = "GoblinNftOrderPayParam", description = "下单所需参数")
@Data
public class GoblinNftOrderPayParam {

    @ApiModelProperty(position = 10, value = "openId微信内网页及小程序支付必传")
    private String openId;

    @ApiModelProperty(position = 11, required = true, value = "skuId")
    @NotBlank(message = "skuId不能为空")
    private String skuId;

    /*@ApiModelProperty(position = 12, value = "平台券码")
    private String platVoucherCode;

    @ApiModelProperty(position = 13, value = "商品券码")
    private String storeVoucherCode;*/

    @ApiModelProperty(position = 14, required = true, value = "支付方式", allowableValues = "alipay,wepay,douyinpay,unionpay,applepay")
    @Pattern(regexp = LnsRegex.Valid.TRIPLE_PF_FOR_PAY, message = "支付方式无效")
    @NotBlank(message = "支付方式不能为空")
    private String payType;

    @ApiModelProperty(position = 15, required = true, value = "支付终端", allowableValues = "app,wap,js,applet")
    @Pattern(regexp = LnsRegex.Valid.TRIPLE_PF_FOR_PAY_TERMINAL, message = "支付终端类型无效")
    @NotBlank(message = "支付终端不能为空")
    private String deviceFrom;

    @ApiModelProperty(position = 16, value = "showUrl 之前h5需要 app不需要再说")
    private String showUrl;

    @ApiModelProperty(position = 17, value = "returnUrl 之前h5需要 app不需要再说")
    private String returnUrl;

    private static final GoblinNftOrderPayParam obj = new GoblinNftOrderPayParam();

    public static GoblinNftOrderPayParam getNew() {
        try {
            return (GoblinNftOrderPayParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftOrderPayParam();
        }
    }


}
