package com.liquidnet.common.third.zxlnft.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 15.NFT平台自身身份绑定，
 * @class: IdentityBindPlatformSelfReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:31
 */
@Data
public class Nft015IdentityBindPlatformSelfReqDto implements Serializable {
    /**
     * 签名信息sign(userIdentification)
     */
    private String signData;
    /**
     * 公钥
     */
    private String pubKey;
    /**
     * 用户唯一标识
     */
    private String userIdentification;
    /**
     * 邮箱验证码
     */
    private String verifyCode;
    private static final Nft015IdentityBindPlatformSelfReqDto obj = new Nft015IdentityBindPlatformSelfReqDto();
    private static final long serialVersionUID = -1497568548722245137L;

    public static Nft015IdentityBindPlatformSelfReqDto getNew() {
        try {
            return (Nft015IdentityBindPlatformSelfReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft015IdentityBindPlatformSelfReqDto();
        }
    }
}
