package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.entity.GoblinBraceletOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 手环-订单VO
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "手环订单vo")
public class GoblinBraceletOrderVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    /**
     * 订单ID
     */
    @ApiModelProperty(value = "订单ID")
    private String orderId;

    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户ID")
    private String userId;

    /**
     * 绑定用户姓名
     */
    @ApiModelProperty(value = "绑定用户姓名")
    private String bindName;

    /**
     * 绑定用户手机号
     */
    @ApiModelProperty(value = "绑定用户手机号")
    private String bindMobile;

    /**
     * 绑定用户身份证号码
     */
    @ApiModelProperty(value = "绑定用户身份证号码")
    private String bindIdcard;

    /**
     * 请求日期
     */
    @ApiModelProperty(value = "请求日期")
    private String reqDate;

    /**
     * 商品描述
     */
    @ApiModelProperty(value = "商品描述")
    private String goodsDesc;

    /**
     * 手环ID
     */
    @ApiModelProperty(value = "手环ID")
    private String wristbandId;

    /**
     *手环金额
     */
    @ApiModelProperty(value = "手环金额")
    private BigDecimal wristbandPrice;

    /**
     *充值金额ID
     */
    @ApiModelProperty(value = "充值金额ID")
    private String amountId;

    /**
     *充值金额
     */
    @ApiModelProperty(value = "充值金额")
    private BigDecimal amountPrice;

    /**
     * 请求流水号
     */
    @ApiModelProperty(value = "请求流水号")
    private String reqSeqId;

    /**
     * 全局流水号
     */
    @ApiModelProperty(value = "全局流水号")
    private String hfSeqId;

    /**
     * 交易类型：
     * T_JSAPI: 微信公众号支付
     * T_MINIAPP: 微信小程序支付
     * A_JSAPI: 支付宝JS
     * A_NATIVE: 支付宝正扫
     * U_NATIVE: 银联正扫
     * U_JSAPI: 银联 JS
     * D_NATIVE: 数字人民币正扫
     * T_H5：微信直连H5支付
     * T_APP：微信APP支付
     * T_NATIVE：微信正扫
     */
    @ApiModelProperty(value = "交易类型")
    private String tradeType;

    /**
     * 用户账单上的交易订单号
     */
    @ApiModelProperty(value = "用户账单上的交易订单号")
    private String outTransId;

    /**
     * 用户账单上的商户订单号
     */
    @ApiModelProperty(value = "用户账单上的商户订单号")
    private String partyOrderId;

    /**
     * 支付完成时间 格式yyyyMMddHHmmss
     */
    @ApiModelProperty(value = "支付完成时间 格式yyyyMMddHHmmss")
    private String endTime;

    /**
     * 入账时间 格式为yyyyMMdd
     */
    @ApiModelProperty(value = "入账时间 格式为yyyyMMdd")
    private String acctDate;

    /**
     * 单价
     */
    @ApiModelProperty(value = "单价")
    private BigDecimal price;

    /**
     * 应付价格
     */
    @ApiModelProperty(value = "应付价格")
    private BigDecimal priceTotal;

    /**
     * 实付价格
     */
    @ApiModelProperty(value = "实付价格")
    private BigDecimal priceActual;

    /**
     * 退款价格
     */
    @ApiModelProperty(value = "退款价格")
    private BigDecimal priceRefund;

    /**
     * 退款扣除的手续费金额
     */
    @ApiModelProperty(value = "退款扣除的手续费金额")
    private BigDecimal refundPriceCharges;

    /**
     * 退款数
     */
    @ApiModelProperty(value = "退款数")
    private Integer refundNumber;

    /**
     * 支付时间
     */
    @ApiModelProperty(value = "支付时间")
    private String timePay;

    /**
     * 订单状态:
     * 0 待付款
     * 1 已付款
     * 2 已关闭
     * 3 正在退款
     * 4 已退款
     * 5 待关闭
     * 6 部分退款
     * 7 退款失败
     */
    @ApiModelProperty(value = "订单状态")
    private Integer status;

    /**
     * 支付状态:
     * 0 未支付
     * 1 已支付
     * 2 支付失败
     */
    @ApiModelProperty(value = "支付状态")
    private Integer payStatus;

    /**
     * 迈之的分订单号
     */
    @ApiModelProperty(value = "迈之的分订单号")
    private String foutTradeNo;

    /**
     * 迈之的设备编号
     */
    @ApiModelProperty(value = "迈之的设备编号")
    private String cardno;

    /**
     * 迈之的分订单号
     */
    @ApiModelProperty(value = "迈之的分订单号")
    private Integer refundStatus;

    /**
     * 迈之的设备编号
     */
    @ApiModelProperty(value = "迈之的设备编号")
    private String refundStatusNote;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    private static final GoblinBraceletOrderVo obj = new GoblinBraceletOrderVo();

    public static GoblinBraceletOrderVo getNew() {
        try {
            return (GoblinBraceletOrderVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new GoblinBraceletOrderVo();
    }

    public GoblinBraceletOrderVo copy(GoblinBraceletOrder goblinBraceletOrder){
        if (goblinBraceletOrder == null) return this;
        BeanUtils.copyProperties(goblinBraceletOrder, this);
        return this;
    }
}

