package com.liquidnet.service.account.funding.dto;

import com.liquidnet.service.account.funding.dto.base.FundingCallParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Map;

/**
 * FundingQueryParam.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/22
 */
@ApiModel(value = "FundingQueryBalanceParam", description = "Parameters of account balance query")
public class FundingQueryBalanceParam extends FundingCallParam {
    private static final long serialVersionUID = -1185012811804710842L;
    @ApiModelProperty(position = 11, required = true, value = "Fund account collection [Map<String,List<String>>]")
    private Map<String,List<String>> finIdWithAccNoMap;

    public Map<String, List<String>> getFinIdWithAccNoMap() {
        return finIdWithAccNoMap;
    }

    public void setFinIdWithAccNoMap(Map<String, List<String>> finIdWithAccNoMap) {
        this.finIdWithAccNoMap = finIdWithAccNoMap;
    }
}
