package com.liquidnet.service.account.wallet.service.processor;

import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.account.common.ErrorConstants;
import com.liquidnet.service.account.common.FinConstants;
import com.liquidnet.service.account.wallet.bo.FinWalletBalanceBo;
import com.liquidnet.service.account.wallet.dto.WalletEditResult;
import com.liquidnet.service.account.wallet.dto.base.WalletContextParam;
import com.liquidnet.service.account.wallet.entity.FinWallet;
import com.liquidnet.service.account.wallet.service.FinWalletService;
import com.liquidnet.service.account.wallet.service.WalletProcessorService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * WalletEditProcessService.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/21
 */
@Service
public class WalletAccountEditProcessor extends WalletProcessorService {
    private static final Logger log = LoggerFactory.getLogger(WalletAccountEditProcessor.class);
    @Autowired
    private FinWalletService walletService;

    @Override
    public WalletEditResult checkInputParams(WalletContextParam context) {
        if (StringUtils.isEmpty(context.getWalletNo())) {
            return new WalletEditResult(ErrorConstants.PARAMS_VALUE_ERROR_CODE, "Invalid walletNo");
        }
        boolean invalidStatus = null == FinConstants.Status.byVal(context.getStatus());
        boolean invalidAlias = null == context.getAlias();
        if (invalidStatus && invalidAlias) {
            return new WalletEditResult(ErrorConstants.PARAMS_VALUE_ERROR_CODE, "Invalid status,alias");
        }
        if ((invalidStatus || !invalidAlias) && context.getAlias().length() > 100) {
            return new WalletEditResult(ErrorConstants.PARAMS_VALUE_ERROR_CODE, "Toolong alias");
        }
        return new WalletEditResult();
    }

    @Override
    public WalletEditResult checkBussinessLogic(WalletContextParam context) {
        return new WalletEditResult();
    }

    @Override
    public WalletEditResult doBussiness(WalletContextParam context) {
        FinWallet wallet = walletService.query(context.getWalletNo());
        if (null == wallet) {
            return new WalletEditResult(ErrorConstants.PARAMS_VALUE_ERROR_CODE, "Not found wallet");
        }

        FinWallet updateWalletInfo = new FinWallet();
        updateWalletInfo.setWalletNo(wallet.getWalletNo());
        updateWalletInfo.setAlias(context.getAlias());
        Integer status = context.getStatus();
        if (null != status) {
            updateWalletInfo.setStatus(status);

            if (FinConstants.Status.DISABLE.getVal() == status) {
                FinWalletBalanceBo balanceBo = walletService.queryBalance(wallet.getFinId(), wallet.getWalletNo());
                if (null == balanceBo) {
                    return new WalletEditResult(ErrorConstants.WALLET_EDIT_ERROR_CODE, ErrorConstants.WALLET_EDIT_ERROR_DESC.concat(":balance verification failed"));
                }
                if (BigDecimal.ZERO.compareTo(balanceBo.getBalanceAvailable()) != 0 || BigDecimal.ZERO.compareTo(balanceBo.getBalancePending()) != 0) {
                    return new WalletEditResult(ErrorConstants.WALLET_EDIT_ERROR_CODE, ErrorConstants.WALLET_EDIT_ERROR_DESC.concat(":balance is not cleared"));
                }

                updateWalletInfo.setClosingTime(context.getCreateTime());
                updateWalletInfo.setClosingOperator(context.getOperator());
            }
        }
        updateWalletInfo.setUpdateTime(context.getCreateTime());
        updateWalletInfo.setUpdateOperator(context.getOperator());

        if (walletService.updateWallet(updateWalletInfo) <= 0) {
            log.warn("Update data failed[wallet.status|alias]:{},[{}]", context.getTradeNo(), JsonUtils.toJson(updateWalletInfo));
            return new WalletEditResult(ErrorConstants.WALLET_EDIT_ERROR_CODE, ErrorConstants.WALLET_EDIT_ERROR_DESC);
        }
        return new WalletEditResult();
    }
}
