package com.liquidnet.service.kylin.controller.partner;


import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dao.ChildPerformanceDao;
import com.liquidnet.service.kylin.dto.param.CheckPerformanceRelationParam;
import com.liquidnet.service.kylin.dto.param.CheckUserParam;
import com.liquidnet.service.kylin.mapper.KylinCheckUserPerformancesMapper;
import com.liquidnet.service.kylin.service.impl.partner.KylinCheckUserPerformancesPartnerServiceImpl;
import com.liquidnet.service.kylin.service.impl.partner.KylinTicketsPartnerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 验票用户可看演出表 前端控制器
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-21
 */
@Api(tags = "第三方-验票账号关联演出")
@RestController
@RequestMapping("partner/checkUser/performance")
public class KylinCheckUserPerformancesPartnerController {

    @Autowired
    private KylinCheckUserPerformancesPartnerServiceImpl userPerformancesPartnerService;

    @PostMapping(value = "")
    @ApiOperation(value = "添加关联关系", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> setPerformance(@RequestBody @Valid CheckUserParam param) {
        return userPerformancesPartnerService.setPerformance(param);
    }

    @DeleteMapping(value = "")
    @ApiOperation(value = "删除关联关系", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<String> delPerformance(@RequestParam("performanceIds") @Size(min = 1) @NotNull List<String> performanceIds,
                                              @RequestParam("checkUserId") String checkUserId) {
        return userPerformancesPartnerService.delPerformance(performanceIds, checkUserId);
    }

    @GetMapping(value = "relation")
    @ApiOperation(value = "关联演出列表", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<ChildPerformanceDao>> childPerformanceList(@RequestParam("merchantId") @NotNull String merchantId,
                                                                           @RequestParam("checkUserId") @NotNull String checkUserId,
                                                                           @RequestParam("page") @NotNull @Min(1) int page,
                                                                           @RequestParam("size") @NotNull @Min(1)int size,
                                                                           @RequestParam("name") String name) {
        return userPerformancesPartnerService.childPerformanceList(merchantId, checkUserId, page, size,name);
    }

    @GetMapping(value = "unRelation")
    @ApiOperation(value = "未关联演出列表", position = 1)
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<ChildPerformanceDao>> unChildPerformanceList(@RequestParam("merchantId") @NotNull String merchantId,
                                                                             @RequestParam("checkUserId") @NotNull String checkUserId,
                                                                             @RequestParam("page") @NotNull @Min(1) int page,
                                                                             @RequestParam("size") @NotNull @Min(1) int size,
                                                                             @RequestParam("name") String name) {
        return userPerformancesPartnerService.unChildPerformanceList(merchantId, checkUserId, page, size,name);
    }
}
