package com.liquidnet.service.consumer.kylin.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.kylin.receiver.ConsumerGoblinCodeReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

@Configuration
public class ConsumerGoblinCodeStreamConfig  extends RedisStreamConfig {
    @Autowired
    ConsumerGoblinCodeReceiver consumerGoblinCodeReceiver;

    public Subscription receiveCodeExamine(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.GoblinQueue.GOBLIN_CODE_OPERA.getGroup(), getConsumerName(MQConst.GoblinQueue.GOBLIN_CODE_OPERA.name() + t)),
                StreamOffset.create(MQConst.GoblinQueue.GOBLIN_CODE_OPERA.getKey(), ReadOffset.lastConsumed()), consumerGoblinCodeReceiver);
    }


    @Bean
    public Subscription codeExamine0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveCodeExamine(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }



}
