package com.liquidnet.common.third.zxlnft.service;

import com.liquidnet.common.third.zxlnft.dto.wallet.*;

public interface WalletSdkService {
  /**
   * 生成助记词
   * @param req
   * @return
   */
  CreateMnemonicResp createMnemonic(CreateMnemonicReq req);

  /**
   * Api签名
   * @param req
   * @return
   */
  GenerateApiSignResp generateApiSign(GenerateApiSignReq req);

  /**
   * 文件上传至cos
   * @param req
   * @return
   */
  UploadToCosResp uploadToCos(UploadToCosReq req);

  /**
   * 文件上传至cos(form-data文件提交)
   * @param req
   * @return
   */
  UploadFileToCosResp uploadFileToCos(UploadFileToCosReq req);

  /**
   * 派生生成子公司钥对
   * @param req
   * @return
   */
  DeriveKeyPairResp deriveKeyPair(DeriveKeyPairReq req);

  /**
   * sdk-签名
   * @param req
   * @return
   */
  SignByPriKeyResp signByPriKey(SignByPriKeyReq req);

  /**
   * sdk-私钥生成对应公钥
   * @param req
   * @return
   */
  PriKey2PubKeyResp priKey2PubKey(PriKey2PubKeyReq req);

  /**
   * sdk-公钥生成对应地址
   * @param req
   * @return
   */
  PubKey2AddressResp pubKey2Address(PubKey2AddressReq req);

  /**
   * sdk-私钥生成对应地址
   * @param req
   * @return
   */
  PriKey2AddressResp priKey2Address(PriKey2AddressReq req);

  /**
   * sdk-签名
   * @param req
   * @return
   */
  VerifyByPubKeyResp verifyByPubKey(VerifyByPubKeyReq req);

  /**
   * sdk-SM3哈希
   * @param req
   * @return
   */
  SM3HashResp sM3Hash(SM3HashReq req);

  /**
   * sdk-SM3哈希EnCode
   * @param req
   * @return
   */
  SM3HashEncodeResp sM3HashEncode(SM3HashEncodeReq req);
}