package com.liquidnet.common.third.zxlnft.service;

import com.liquidnet.common.third.zxlnft.dto.nft.*;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxlnftSdkService
 * @Package com.liquidnet.common.third.zxlnft.service
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/17 15:53
 */
public interface ZxlnftSdkService {
    /**
     * 1.下发注册实名验证码接口
     * @param req
     * @return
     */
    Nft001RegisterVerifyCodeResp nft001RegisterVerifyCode(Nft001RegisterVerifyCodeReq req);

    /**
     * 2.自然人注册实名接口
     * @param req
     * @return
     */
    Nft002RegisterPersonResp nft002RegisterPerson(Nft002RegisterPersonReq req);

    /**
     * 3.自然人注册实名（使用nft平台签名)接口
     * @param req
     * @return
     */
    Nft003RegisterPersonPlatformResp nft001RegisterVerifyCode(Nft003RegisterPersonPlatformReq req);

    /**
     * 4.营业执照上传接口
     * @param req
     * @return
     */
    Nft004BusinessLicenseUploadResp nft001RegisterVerifyCode(Nft004BusinessLicenseUploadReq req);

    /**
     * 5.营业执照上传（使用nft平台签名）接口
     * @param req
     * @return
     */
    Nft005BusinessLicenseUploadPlatformResp nft001RegisterVerifyCode(Nft005BusinessLicenseUploadPlatformReq req);

    /**
     * 6.电子公函上传接口
     * @param req
     * @return
     */
    Nft006OfficialLetterUploadResp nft001RegisterVerifyCode(Nft006OfficialLetterUploadReq req);

    /**
     * 7.电子公函上传（使用nft平台签名）接口
     * @param req
     * @return
     */
    Nft007OfficialLetterUploadPlatformResp nft001RegisterVerifyCode(Nft007OfficialLetterUploadPlatformReq req);

    /**
     * 8.图片内容检测
     * @param req
     * @return
     */
    Nft008QueryImageModerationResp nft001RegisterVerifyCode(Nft008QueryImageModerationReq req);

    /**
     * 9.企业注册实名接口
     * @param req
     * @return
     */
    Nft009RegisterCompanyResp nft001RegisterVerifyCode(Nft009RegisterCompanyReq req);

    /**
     * 10.企业注册实名（使用nft平台签名）接口
     * @param req
     * @return
     */
    Nft010RegisterCompanyPlatformResp nft001RegisterVerifyCode(Nft010RegisterCompanyPlatformReq req);

    /**
     * 11.下发查询用户信息验证码接
     * @param req
     * @return
     */
    Nft011UserQueryVerifyCodeResp nft001RegisterVerifyCode(Nft011UserQueryVerifyCodeReq req);

    /**
     * 12.查询用户信息接口
     * @param req
     * @return
     */
    Nft012UserQueryResp nft001RegisterVerifyCode(Nft012UserQueryReq req);

    /**
     * 13.NFT地址绑定接口
     * @param req
     * @return
     */
    Nft013IdentityBindSubmitResp nft001RegisterVerifyCode(Nft013IdentityBindSubmitReq req);

    /**
     * 14.受信平台NFT身份绑定接口
     * @param req
     * @return
     */
    Nft014IdentityBindSubmitByTrustedResp nft001RegisterVerifyCode(Nft014IdentityBindSubmitByTrustedReq req);

    /**
     * 15.NFT平台自身身份绑定，
     * @param req
     * @return
     */
    Nft015IdentityBindPlatformSelfResp nft001RegisterVerifyCode(Nft015IdentityBindPlatformSelfReq req);

    /**
     * 16.绑定状态批量查询接口
     * @param req
     * @return
     */
    Nft016IdentityBindQueryResp nft001RegisterVerifyCode(Nft016IdentityBindQueryReq req);

    /**
     * 17.地址与身份对应关系核验接
     * @param req
     * @return
     */
    Nft017IdentityVerifyIdentityResp nft001RegisterVerifyCode(Nft017IdentityVerifyIdentityReq req);

    /**
     * 18.请求人脸核身h5url
     * @param req
     * @return
     */
    Nft018FaceUrlResp nft001RegisterVerifyCode(Nft018FaceUrlReq req);

    /**
     * 19.通过用户地址请求人脸核身h5url
     * @param req
     * @return
     */
    Nft019FaceUrlByAddressResp nft001RegisterVerifyCode(Nft019FaceUrlByAddressReq req);

    /**
     * 20.人身核对结果查询接口
     * @param req
     * @return
     */
    Nft020FaceQueryResp nft001RegisterVerifyCode(Nft020FaceQueryReq req);

    /**
     * 21.查询素材地址接口
     * @param req
     * @return
     */
    Nft021UploadUrlResp nft001RegisterVerifyCode(Nft021UploadUrlReq req);

    /**
     * 22.生成素材上传临时密钥接口
     * @param req
     * @return
     */
    Nft022UploadSecretResp nft001RegisterVerifyCode(Nft022UploadSecretReq req);

    /**
     * 23.申请积分
     * @param req
     * @return
     */
    Nft023PointApplyResp nft001RegisterVerifyCode(Nft023PointApplyReq req);

    /**
     * 24.查询积分申请结果
     * @param req
     * @return
     */
    Nft024PointApplyResultResp nft001RegisterVerifyCode(Nft024PointApplyResultReq req);

    /**
     * 25.平台积分转移
     * @param req
     * @return
     */
    Nft025PointTransferResp nft001RegisterVerifyCode(Nft025PointTransferReq req);

    /**
     * 26.平台积分转移状态查询
     * @param req
     * @return
     */
    Nft026PointTransferResultResp nft001RegisterVerifyCode(Nft026PointTransferResultReq req);

    /**
     * 27.积分销毁
     * @param req
     * @return
     */
    Nft027PointDestroyResp nft001RegisterVerifyCode(Nft027PointDestroyReq req);

    /**
     * 28.查询积分销毁结果
     * @param req
     * @return
     */
    Nft028PointDestoryResultResp nft001RegisterVerifyCode(Nft028PointDestoryResultReq req);

    /**
     * 29.积分查询
     * @param req
     * @return
     */
    Nft029PointQueryResp nft001RegisterVerifyCode(Nft029PointQueryReq req);

    /**
     * 30.NFT 系列声明
     * @param req
     * @return
     */
    Nft030SeriesClaimResp nft001RegisterVerifyCode(Nft030SeriesClaimReq req);

    /**
     * 31.查询NFT系列声明结果
     * @param req
     * @return
     */
    Nft031SeriesClaimResultResp nft001RegisterVerifyCode(Nft031SeriesClaimResultReq req);

    /**
     * 32.查询系列信息
     * @param req
     * @return
     */
    Nft032SeriesResp nft001RegisterVerifyCode(Nft032SeriesReq req);

    /**
     * 33.查询该账户资产归属的系列列表
     * @param req
     * @return
     */
    Nft033SeriesListResp nft001RegisterVerifyCode(Nft033SeriesListReq req);

    /**
     * 34.发行 NFT
     * @param req
     * @return
     */
    Nft034PublishResp nft001RegisterVerifyCode(Nft034PublishReq req);

    /**
     * 35.查询 NFT发行结果
     * @param req
     * @return
     */
    Nft035PublishResultResp nft001RegisterVerifyCode(Nft035PublishResultReq req);

    /**
     * 36.NFT元信息查询
     * @param req
     * @return
     */
    Nft036InfoResp nft001RegisterVerifyCode(Nft036InfoReq req);

    /**
     * 37.查询账户NFT列表
     * @param req
     * @return
     */
    Nft037AddressListResp nft001RegisterVerifyCode(Nft037AddressListReq req);

    /**
     * 38.查询无系列NFT列表
     * @param req
     * @return
     */
    Nft038AddressWithoutSeriesListResp nft001RegisterVerifyCode(Nft038AddressWithoutSeriesListReq req);

    /**
     * 39.查询NFT交易信息列表
     * @param req
     * @return
     */
    Nft039TradeListResp nft001RegisterVerifyCode(Nft039TradeListReq req);

    /**
     * 40.查询转入NFT交易信息列表
     * @param req
     * @return
     */
    Nft040TradeInListResp nft001RegisterVerifyCode(Nft040TradeInListReq req);

    /**
     * 41.查询转出NFT交易信息列表
     * @param req
     * @return
     */
    Nft041TradeOutListResp nft001RegisterVerifyCode(Nft041TradeOutListReq req);

    /**
     * 42.通过地址查询全部NFT交易信息列表
     * @param req
     * @return
     */
    Nft042TradeAllListResp nft001RegisterVerifyCode(Nft042TradeAllListReq req);

    /**
     * 43.NFT 购买
     * @param req
     * @return
     */
    Nft043BuyResp nft001RegisterVerifyCode(Nft043BuyReq req);

    /**
     * 44.查询 NFT 购买结果
     * @param req
     * @return
     */
    Nft044BuyResultResp nft001RegisterVerifyCode(Nft044BuyResultReq req);

    /**
     * 45.查询nft购买支付结果
     * @param req
     * @return
     */
    Nft045BuyPayResultResp nft001RegisterVerifyCode(Nft045BuyPayResultReq req);

    /**
     * 46.NFT 转移
     * @param req
     * @return
     */
    Nft046TransferResp nft001RegisterVerifyCode(Nft046TransferReq req);

    /**
     * 47.NFT 同名转移
     * @param req
     * @return
     */
    Nft047SelfTransferResp nft001RegisterVerifyCode(Nft047SelfTransferReq req);

    /**
     * 48.NFT 批量转移
     * @param req
     * @return
     */
    Nft048BatchTransferResp nft001RegisterVerifyCode(Nft048BatchTransferReq req);

    /**
     * 49.NFT转移状态查询
     * @param req
     * @return
     */
    Nft049TransferResultResp nft001RegisterVerifyCode(Nft049TransferResultReq req);

    /**
     * 50.NFT销售状态变更
     * @param req
     * @return
     */
    Nft050StatusUpdateResp nft001RegisterVerifyCode(Nft050StatusUpdateReq req);

    /**
     * 51.NFT销售状态变更查询
     * @param req
     * @return
     */
    Nft051StatusUpdateResultResp nft001RegisterVerifyCode(Nft051StatusUpdateResultReq req);

    /**
     * 52.NFT售价变更
     * @param req
     * @return
     */
    Nft052PriceUpdateResp nft001RegisterVerifyCode(Nft052PriceUpdateReq req);

    /**
     * 53.NFT 售价变更状态查询
     * @param req
     * @return
     */
    Nft053PriceUpdateResultResp nft001RegisterVerifyCode(Nft053PriceUpdateResultReq req);
}
