/*     */ package com.liquidnet.common.third.zxlnft.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftConstant;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.dto.wallet.*;
import com.liquidnet.common.third.zxlnft.service.WalletSdkService;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;

@Slf4j
@Service
public class WalletSdkServiceImpl implements WalletSdkService {

  @Autowired
  private ZxlnftConfig zxlnftConfig;

  private static MultiValueMap<String, String> commonHeader = new LinkedMultiValueMap();
  private static MultiValueMap<String, String> commonParams = new LinkedMultiValueMap();

  @Override
  public CreateMnemonicResp createMnemonic(CreateMnemonicReq req) {
//    commonHeader.clear();
//    commonHeader.add("Authorization", "Bearer "+this.getAccessToken());

    JSONObject json = new JSONObject();

    String requestUrl = zxlnftConfig.getWalletSdkUrl() + ZxlnftConstant.WALLET_SDK_01_CREATE_MNEMONIC;
    log.info("createMnemonic--->>> request url : {}  body : {} ",requestUrl, json.toString());

    String response = null;
    try {
      response = HttpUtil.postJson(requestUrl,json.toString());
    } catch(HttpClientErrorException e) {
      log.error("createMnemonic error", e);
      if(e.getRawStatusCode() == 400){
        JSONObject jsonObject = JsonUtils.fromJson(e.getResponseBodyAsString(), new TypeReference<JSONObject>() {});
        return null;
      }
    }catch (Exception e) {
      log.error("createUser error",e);
    }
    log.info("createMnemonic--->>> response : {} ",response);

    if (StringUtils.isEmpty(response)) {
      return null;
    }
    CreateMnemonicResp resp = JsonUtils.fromJson(response,CreateMnemonicResp.class);
    return resp;
  }

  @Override
  public GenerateApiSignResp generateApiSign(GenerateApiSignReq req) {
//    commonHeader.clear();
//    commonHeader.add("Authorization", "Bearer "+this.getAccessToken());

    JSONObject json = new JSONObject();
    json.put("appId", "");
    json.put("apKey", "");

    String requestUrl = zxlnftConfig.getWalletSdkUrl() + ZxlnftConstant.WALLET_SDK_02_GENERATE_API_SIGN;
    log.info("generateApiSign--->>> request url : {}  body : {} ",requestUrl, json.toString());

    String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
    try {
      response = HttpUtil.postJson(requestUrl,json.toString(),commonHeader);
    } catch(HttpClientErrorException e) {
      log.error("generateApiSign error", e);
    }catch (Exception e) {
      log.error("generateApiSign error",e);
    }
    log.info("generateApiSign--->>> response : {} ",response);

    if (StringUtils.isEmpty(response)) {
      return null;
    }
    GenerateApiSignResp resp = JsonUtils.fromJson(response,GenerateApiSignResp.class);
    return resp;
  }

  @Override
  public UploadToCosResp uploadToCos(UploadToCosReq req) {
    return null;
  }

  @Override
  public UploadFileToCosResp uploadFileToCos(UploadFileToCosReq req) {
    return null;
  }

  @Override
  public DeriveKeyPairResp deriveKeyPair(DeriveKeyPairReq req) {
    return null;
  }

  @Override
  public SignByPriKeyResp signByPriKey(SignByPriKeyReq req) {
    return null;
  }

  @Override
  public PriKey2PubKeyResp priKey2PubKey(PriKey2PubKeyReq req) {
    return null;
  }

  @Override
  public PubKey2AddressResp pubKey2Address(PubKey2AddressReq req) {
    return null;
  }

  @Override
  public PriKey2AddressResp priKey2Address(PriKey2AddressReq req) {
    return null;
  }

  @Override
  public VerifyByPubKeyResp verifyByPubKey(VerifyByPubKeyReq req) {
    return null;
  }

  @Override
  public SM3HashResp sM3Hash(SM3HashReq req) {
    return null;
  }

  @Override
  public SM3HashEncodeResp sM3HashEncode(SM3HashEncodeReq req) {
    return null;
  }
}