package com.liquidnet.common.third.zxlnft.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftConstant;
import com.liquidnet.common.third.zxlnft.dto.nft.*;
import com.liquidnet.common.third.zxlnft.service.ZxlnftSdkService;
import com.liquidnet.commons.lang.util.HttpUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;

@Slf4j
@Service
public class ZxlnftSdkServiceImpl implements ZxlnftSdkService
{
    @Autowired
    private ZxlnftConfig zxlnftConfig;

    private static MultiValueMap<String, String> commonHeader = new LinkedMultiValueMap();
    private static MultiValueMap<String, String> commonParams = new LinkedMultiValueMap();

    @Override
    public Nft001RegisterVerifyCodeResp nft001RegisterVerifyCode(Nft001RegisterVerifyCodeReq req) {
        return null;
    }

    @Override
    public Nft002RegisterPersonResp nft002RegisterPerson(Nft002RegisterPersonReq req) {
        return null;
    }

    @Override
    public Nft003RegisterPersonPlatformResp nft001RegisterVerifyCode(Nft003RegisterPersonPlatformReq req) {
        return null;
    }

    @Override
    public Nft004BusinessLicenseUploadResp nft001RegisterVerifyCode(Nft004BusinessLicenseUploadReq req) {
        return null;
    }

    @Override
    public Nft005BusinessLicenseUploadPlatformResp nft001RegisterVerifyCode(Nft005BusinessLicenseUploadPlatformReq req) {
        return null;
    }

    @Override
    public Nft006OfficialLetterUploadResp nft001RegisterVerifyCode(Nft006OfficialLetterUploadReq req) {
        return null;
    }

    @Override
    public Nft007OfficialLetterUploadPlatformResp nft001RegisterVerifyCode(Nft007OfficialLetterUploadPlatformReq req) {
        return null;
    }

    @Override
    public Nft008QueryImageModerationResp nft001RegisterVerifyCode(Nft008QueryImageModerationReq req) {
        return null;
    }

    @Override
    public Nft009RegisterCompanyResp nft001RegisterVerifyCode(Nft009RegisterCompanyReq req) {
        return null;
    }

    @Override
    public Nft010RegisterCompanyPlatformResp nft001RegisterVerifyCode(Nft010RegisterCompanyPlatformReq req) {
        return null;
    }

    @Override
    public Nft011UserQueryVerifyCodeResp nft001RegisterVerifyCode(Nft011UserQueryVerifyCodeReq req) {
        return null;
    }

    @Override
    public Nft012UserQueryResp nft001RegisterVerifyCode(Nft012UserQueryReq req) {
        return null;
    }

    @Override
    public Nft013IdentityBindSubmitResp nft001RegisterVerifyCode(Nft013IdentityBindSubmitReq req) {
        return null;
    }

    @Override
    public Nft014IdentityBindSubmitByTrustedResp nft001RegisterVerifyCode(Nft014IdentityBindSubmitByTrustedReq req) {
        return null;
    }

    @Override
    public Nft015IdentityBindPlatformSelfResp nft001RegisterVerifyCode(Nft015IdentityBindPlatformSelfReq req) {
        return null;
    }

    @Override
    public Nft016IdentityBindQueryResp nft001RegisterVerifyCode(Nft016IdentityBindQueryReq req) {
        //    commonHeader.clear();
//    commonHeader.add("Authorization", "Bearer "+this.getAccessToken());

        JSONObject json = new JSONObject();
        json.put("appId", "");
        json.put("apKey", "");

        String requestUrl = zxlnftConfig.getNftApiUrl() + ZxlnftConstant.ZXL_NFT_016_IDENTITY_BIND_QUERY_URL;
        log.info("nft001RegisterVerifyCode--->>> request url : {}  body : {} ",requestUrl, json.toString());

        String response = null;
//        ObjectNode objectNode = JsonUtils.OM().createObjectNode();
        try {
            response = HttpUtil.postJson(requestUrl,json.toString(),commonHeader);
        } catch(HttpClientErrorException e) {
            log.error("nft001RegisterVerifyCode error", e);
        }catch (Exception e) {
            log.error("nft001RegisterVerifyCode error",e);
        }
        log.info("nft001RegisterVerifyCode--->>> response : {} ",response);

        if (StringUtils.isEmpty(response)) {
            return null;
        }
        Nft016IdentityBindQueryResp resp = JsonUtils.fromJson(response,Nft016IdentityBindQueryResp.class);
        return resp;
    }

    @Override
    public Nft017IdentityVerifyIdentityResp nft001RegisterVerifyCode(Nft017IdentityVerifyIdentityReq req) {
        return null;
    }

    @Override
    public Nft018FaceUrlResp nft001RegisterVerifyCode(Nft018FaceUrlReq req) {
        return null;
    }

    @Override
    public Nft019FaceUrlByAddressResp nft001RegisterVerifyCode(Nft019FaceUrlByAddressReq req) {
        return null;
    }

    @Override
    public Nft020FaceQueryResp nft001RegisterVerifyCode(Nft020FaceQueryReq req) {
        return null;
    }

    @Override
    public Nft021UploadUrlResp nft001RegisterVerifyCode(Nft021UploadUrlReq req) {
        return null;
    }

    @Override
    public Nft022UploadSecretResp nft001RegisterVerifyCode(Nft022UploadSecretReq req) {
        return null;
    }

    @Override
    public Nft023PointApplyResp nft001RegisterVerifyCode(Nft023PointApplyReq req) {
        return null;
    }

    @Override
    public Nft024PointApplyResultResp nft001RegisterVerifyCode(Nft024PointApplyResultReq req) {
        return null;
    }

    @Override
    public Nft025PointTransferResp nft001RegisterVerifyCode(Nft025PointTransferReq req) {
        return null;
    }

    @Override
    public Nft026PointTransferResultResp nft001RegisterVerifyCode(Nft026PointTransferResultReq req) {
        return null;
    }

    @Override
    public Nft027PointDestroyResp nft001RegisterVerifyCode(Nft027PointDestroyReq req) {
        return null;
    }

    @Override
    public Nft028PointDestoryResultResp nft001RegisterVerifyCode(Nft028PointDestoryResultReq req) {
        return null;
    }

    @Override
    public Nft029PointQueryResp nft001RegisterVerifyCode(Nft029PointQueryReq req) {
        return null;
    }

    @Override
    public Nft030SeriesClaimResp nft001RegisterVerifyCode(Nft030SeriesClaimReq req) {
        return null;
    }

    @Override
    public Nft031SeriesClaimResultResp nft001RegisterVerifyCode(Nft031SeriesClaimResultReq req) {
        return null;
    }

    @Override
    public Nft032SeriesResp nft001RegisterVerifyCode(Nft032SeriesReq req) {
        return null;
    }

    @Override
    public Nft033SeriesListResp nft001RegisterVerifyCode(Nft033SeriesListReq req) {
        return null;
    }

    @Override
    public Nft034PublishResp nft001RegisterVerifyCode(Nft034PublishReq req) {
        return null;
    }

    @Override
    public Nft035PublishResultResp nft001RegisterVerifyCode(Nft035PublishResultReq req) {
        return null;
    }

    @Override
    public Nft036InfoResp nft001RegisterVerifyCode(Nft036InfoReq req) {
        return null;
    }

    @Override
    public Nft037AddressListResp nft001RegisterVerifyCode(Nft037AddressListReq req) {
        return null;
    }

    @Override
    public Nft038AddressWithoutSeriesListResp nft001RegisterVerifyCode(Nft038AddressWithoutSeriesListReq req) {
        return null;
    }

    @Override
    public Nft039TradeListResp nft001RegisterVerifyCode(Nft039TradeListReq req) {
        return null;
    }

    @Override
    public Nft040TradeInListResp nft001RegisterVerifyCode(Nft040TradeInListReq req) {
        return null;
    }

    @Override
    public Nft041TradeOutListResp nft001RegisterVerifyCode(Nft041TradeOutListReq req) {
        return null;
    }

    @Override
    public Nft042TradeAllListResp nft001RegisterVerifyCode(Nft042TradeAllListReq req) {
        return null;
    }

    @Override
    public Nft043BuyResp nft001RegisterVerifyCode(Nft043BuyReq req) {
        return null;
    }

    @Override
    public Nft044BuyResultResp nft001RegisterVerifyCode(Nft044BuyResultReq req) {
        return null;
    }

    @Override
    public Nft045BuyPayResultResp nft001RegisterVerifyCode(Nft045BuyPayResultReq req) {
        return null;
    }

    @Override
    public Nft046TransferResp nft001RegisterVerifyCode(Nft046TransferReq req) {
        return null;
    }

    @Override
    public Nft047SelfTransferResp nft001RegisterVerifyCode(Nft047SelfTransferReq req) {
        return null;
    }

    @Override
    public Nft048BatchTransferResp nft001RegisterVerifyCode(Nft048BatchTransferReq req) {
        return null;
    }

    @Override
    public Nft049TransferResultResp nft001RegisterVerifyCode(Nft049TransferResultReq req) {
        return null;
    }

    @Override
    public Nft050StatusUpdateResp nft001RegisterVerifyCode(Nft050StatusUpdateReq req) {
        return null;
    }

    @Override
    public Nft051StatusUpdateResultResp nft001RegisterVerifyCode(Nft051StatusUpdateResultReq req) {
        return null;
    }

    @Override
    public Nft052PriceUpdateResp nft001RegisterVerifyCode(Nft052PriceUpdateReq req) {
        return null;
    }

    @Override
    public Nft053PriceUpdateResultResp nft001RegisterVerifyCode(Nft053PriceUpdateResultReq req) {
        return null;
    }
}