package com.liquidnet.common.third.zxlnft.util;

import com.liquidnet.common.third.zxlnft.dto.wallet.CreateMnemonicReq;
import com.liquidnet.common.third.zxlnft.dto.wallet.CreateMnemonicResp;
import com.liquidnet.common.third.zxlnft.dto.wallet.GenerateApiSignReq;
import com.liquidnet.common.third.zxlnft.dto.wallet.GenerateApiSignResp;
import com.liquidnet.common.third.zxlnft.service.WalletSdkService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: EasemobUtil
 * @Package com.liquidnet.common.third.easemob.util
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/6 16:08
 */
@Slf4j
@Component
public class ZxlnftSdkUtil {
    @Autowired
    private WalletSdkService walletSdkService;

    private static MultiValueMap<String, String> commonHeader = new LinkedMultiValueMap();
    private static MultiValueMap<String, String> commonParams = new LinkedMultiValueMap();

    public CreateMnemonicResp createMnemonic(CreateMnemonicReq req){
        CreateMnemonicResp resp = walletSdkService.createMnemonic(req);
        return resp;
    }

    public GenerateApiSignResp generateApiSign(GenerateApiSignReq req){
        GenerateApiSignResp resp = walletSdkService.generateApiSign(req);
        return resp;
    }
}
