package com.liquidnet.service.feign.platform.task;

import com.liquidnet.service.base.ResponseDto;
import feign.hystrix.FallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Component
@FeignClient(
        name = "liquidnet-service-platform",
        contextId = "FeignPlatformErpTaskClient",
        path = "platform",
        url = "${liquidnet.service.platform.url}",
        fallback = FallbackFactory.Default.class
)
public interface FeignPlatformErpTaskClient {


    @PostMapping("wdt/syncErpSpuStock")
    ResponseDto<Boolean> syncErpSpuStock(@RequestParam("spuId") String spuId,@RequestParam("min") Integer min);
}
