package com.liquidnet.service.adam.controller;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dypnsapi.model.v20170525.GetMobileRequest;
import com.aliyuncs.dypnsapi.model.v20170525.GetMobileResponse;
import com.aliyuncs.exceptions.ClientException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.cache.redisson.util.RedisLockUtil;
import com.liquidnet.commons.lang.core.JwtValidator;
import com.liquidnet.commons.lang.util.*;
import com.liquidnet.service.adam.dto.AdamThirdPartParam;
import com.liquidnet.service.adam.dto.vo.AdamLoginInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.service.*;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.UserPathDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.HttpClientErrorException;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

import static com.liquidnet.service.adam.constant.AdamRedisConst.LOCK_KEY_USMS_MOBILE;

@ApiSupport(order = 10010)
@Api(tags = "用户登录")
@Slf4j
@Validated
@RestController
@RequestMapping("")
public class AdamLoginController {
    @Autowired
    Environment env;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    JwtValidator jwtValidator;
    @Autowired
    DefaultAcsClient defaultAcsClient;
    @Autowired
    AdamRdmService adamRdmService;
    @Autowired
    IAdamUserService adamUserService;


    private static final String PHP_API_SMS_CODE_SEND = "/smsCode";
    private static final String PHP_API_SMS_CODE_VALID = "/smsValidation";

    /*@ApiOperationSupport(order = 1)
    @ApiOperation(value = "手机号密码登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", dataType = "String", name = "mobile", value = "手机号"),
            @ApiImplicitParam(type = "form", dataType = "String", name = "password", value = "密码"),
    })
    @PostMapping(value = {""})
    public ResponseDto<AdamLoginInfoVo> loginByPwd(@RequestParam String mobile, @RequestParam String password) {
        log.info("mobile:{},pwd:{}", mobile, password);
        DigestUtils.md5DigestAsHex((password + "salt_").getBytes(StandardCharsets.UTF_8));


        return ResponseDto.success(AdamLoginInfoVo.getNew());
    }*/

    @GetMapping(value = {"gen"})
    public void genID() {
        log.debug("-nextSnowId:{}", IDGenerator.nextSnowId());
        log.debug("nextMilliId:{}", IDGenerator.nextMilliId());
        log.debug("nextMilliId:{}", IDGenerator.nextTimeId());
        log.debug("nextMilliId:{}", IDGenerator.get32UUID());
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "发送验证码")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "mobile", value = "手机号"),
    })
    @GetMapping(value = {"send"})
    public ResponseDto<Object> sendSms(@Pattern(regexp = "\\d{11}", message = "手机号格式有误") @RequestParam String mobile) {
        log.debug("send to mobile:{}", mobile);
        if (RedisLockUtil.tryLock(LOCK_KEY_USMS_MOBILE + mobile, 1, 5)) {
            Map<String, Object> respMap = null;
            String respStr = null;
            try {
                LinkedMultiValueMap<String, String> paramsMap = new LinkedMultiValueMap<>();
                paramsMap.add("mobile", mobile);

                long s = System.currentTimeMillis();
                respStr = HttpUtil.postToPhpApi(env.getProperty("liquidnet.url-service.url") + PHP_API_SMS_CODE_SEND, paramsMap);
                log.debug("###PHP.API[{}].RESP[{}]", PHP_API_SMS_CODE_SEND, respStr);
                log.debug("#PHP.API耗时:{}ms", System.currentTimeMillis() - s);
                respMap = JsonUtils.fromJson(respStr, Map.class);
            } catch (Exception e) {
                RedisLockUtil.unlock(LOCK_KEY_USMS_MOBILE + mobile);
                if (e instanceof HttpClientErrorException) {
                    log.error("PHP.API验证码发送异常[mobile:{},respStr:{},ex:{}]", mobile, respStr, e.getLocalizedMessage());
                    HttpClientErrorException ex = (HttpClientErrorException) e;
                    JsonNode exBody = JsonUtils.fromJson(ex.getResponseBodyAsString(), JsonNode.class);
                    return ResponseDto.failure("10003", exBody.get("message").asText());
                }
                log.error("PHP.API验证码发送异常[mobile:{},respStr:{}]", mobile, respStr, e);
                return ResponseDto.failure(ErrorMapping.get("10003"));
            }
            if (!CollectionUtils.isEmpty(respMap) && StringUtils.equalsIgnoreCase("OK", (String) respMap.get("message"))) {
                return ResponseDto.success();
            } else {
                RedisLockUtil.unlock(LOCK_KEY_USMS_MOBILE + mobile);
                log.warn("PHP.API验证码发送失败[mobile:{},respStr:{}]", mobile, respStr);
                return ResponseDto.failure(ErrorMapping.get("10003"));
            }
        } else {
            return ResponseDto.failure(ErrorMapping.get("10000"));
        }
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "手机验证码登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "body", required = true, dataType = "String", name = "mobile", value = "手机号"),
            @ApiImplicitParam(type = "body", required = true, dataType = "String", name = "code", value = "验证码"),
    })
    @PostMapping(value = {"login/sms"})
    public ResponseDto<AdamLoginInfoVo> loginBySms(@Pattern(regexp = "\\d{11}", message = "手机号格式有误")
                                                   @RequestParam String mobile,
                                                   @Pattern(regexp = "\\d{6}", message = "验证码格式有误")
                                                   @RequestParam String code) {
        log.debug("mobile:{},code:{}", mobile, code);
        if (!this.checkSmsCode(mobile, code)) return ResponseDto.failure(ErrorMapping.get("10004"));

        String uid = adamRdmService.getUidByMobile(mobile);
        boolean toRegister = StringUtils.isEmpty(uid);

        AdamUserInfoVo userInfoVo;
        if (toRegister) {
            userInfoVo = adamUserService.register(mobile);
            if (null == userInfoVo) {
                return ResponseDto.failure(ErrorMapping.get("10000"));
            }
        } else {
            userInfoVo = adamRdmService.getUserInfoVoByUid(uid);
        }

        AdamLoginInfoVo loginInfoVo = AdamLoginInfoVo.getNew();
        if (!toRegister) {
//            loginInfoVo.setRealNameInfo(adamRdmService.getRealInfoVoByUid(userInfoVo.getUid()));
//            loginInfoVo.setThirdPartInfo(adamRdmService.getThirdPartVoListByUid(userInfoVo.getUid()));
            loginInfoVo.setUserMemberVo(adamRdmService.getUserMemberVoByUid(userInfoVo.getUid()));
        }
//        loginInfoVo.setMemberVo(adamRdmService.getMemberSimpleVo());
        loginInfoVo.setUserInfo(userInfoVo);
        loginInfoVo.setToken(this.ssoProcess(userInfoVo));
        loginInfoVo.getUserInfo().setMobile(SensitizeUtil.custom(userInfoVo.getMobile(), 3, 4));
        log.info(UserPathDto.setData(toRegister ? "注册":"登录", ServletUtils.getRequest().getParameterMap(), loginInfoVo));
        return ResponseDto.success(loginInfoVo);
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "手机号一键登录")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "accessToken", value = "访问令牌"),
    })
    @PostMapping(value = {"login/mobile"})
    public ResponseDto<AdamLoginInfoVo> loginByMobile(@NotBlank(message = "访问令牌不能为空") @RequestParam String accessToken) {
        log.debug("login by mobile access token:{}", accessToken);
        String mobile = this.getMobile(accessToken);
        if (StringUtils.isEmpty(mobile)) return ResponseDto.failure(ErrorMapping.get("10005"));

        String uid = adamRdmService.getUidByMobile(mobile);
        boolean toRegister = StringUtils.isEmpty(uid);

        AdamUserInfoVo userInfoVo;
        if (toRegister) {
            userInfoVo = adamUserService.register(mobile);
            if (null == userInfoVo) {
                return ResponseDto.failure(ErrorMapping.get("10000"));
            }
        } else {
            userInfoVo = adamRdmService.getUserInfoVoByUid(uid);
        }

        AdamLoginInfoVo loginInfoVo = AdamLoginInfoVo.getNew();
        if (!toRegister) {
//            loginInfoVo.setRealNameInfo(adamRdmService.getRealInfoVoByUid(userInfoVo.getUid()));
//            loginInfoVo.setThirdPartInfo(adamRdmService.getThirdPartVoListByUid(userInfoVo.getUid()));
            loginInfoVo.setUserMemberVo(adamRdmService.getUserMemberVoByUid(userInfoVo.getUid()));
        }
//        loginInfoVo.setMemberVo(adamRdmService.getMemberSimpleVo());
        loginInfoVo.setUserInfo(userInfoVo);
        loginInfoVo.setToken(this.ssoProcess(userInfoVo));
        loginInfoVo.getUserInfo().setMobile(SensitizeUtil.custom(userInfoVo.getMobile(), 3, 4));
        log.info(UserPathDto.setData(toRegister ? "注册":"登录", ServletUtils.getRequest().getParameterMap(), loginInfoVo));
        return ResponseDto.success(loginInfoVo);
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "第三方账号登录")
    @PostMapping(value = {"login/tpa"})
    public ResponseDto<AdamLoginInfoVo> loginByTpa(@Valid @RequestBody AdamThirdPartParam parameter) {
        log.debug("login by tpa:{}", JsonUtils.toJson(parameter));
        boolean toRegister = false;
        AdamLoginInfoVo loginInfoVo = AdamLoginInfoVo.getNew();
        if (StringUtils.isEmpty(parameter.getMobile())) {
            String uid = adamRdmService.getUidByPlatformOpenId(parameter.getPlatform(), parameter.getOpenId());
            if (StringUtils.isEmpty(uid)) return ResponseDto.failure(ErrorMapping.get("10006"));

            loginInfoVo.setUserInfo(adamRdmService.getUserInfoVoByUid(uid));
//            loginInfoVo.setRealNameInfo(adamRdmService.getRealInfoVoByUid(uid));
//            loginInfoVo.setThirdPartInfo(adamRdmService.getThirdPartVoListByUid(uid));
            loginInfoVo.setUserMemberVo(adamRdmService.getUserMemberVoByUid(uid));
//            loginInfoVo.setMemberVo(adamRdmService.getMemberSimpleVo());
        } else {// 新账号注册
            if (!this.checkSmsCode(parameter.getMobile(), parameter.getCode())) {
                return ResponseDto.failure(ErrorMapping.get("10004"));
            }
            AdamUserInfoVo registerUserInfo = adamUserService.register(parameter);
            if (null == registerUserInfo) {
                return ResponseDto.failure(ErrorMapping.get("10000"));
            }
            toRegister = true;
            loginInfoVo.setUserInfo(registerUserInfo);
            loginInfoVo.setThirdPartInfo(adamRdmService.getThirdPartVoListByUid(registerUserInfo.getUid()));
//            loginInfoVo.setMemberVo(adamRdmService.getMemberSimpleVo());
        }
        loginInfoVo.setToken(this.ssoProcess(loginInfoVo.getUserInfo()));
        loginInfoVo.getUserInfo().setMobile(SensitizeUtil.custom(loginInfoVo.getUserInfo().getMobile(), 3, 4));
        log.info(UserPathDto.setData(toRegister ? "注册":"登录", ServletUtils.getRequest().getParameterMap(), loginInfoVo));
        return ResponseDto.success(loginInfoVo);
    }

    @ApiOperationSupport(order = 6)
    @ApiOperation(value = "登出")
    @PostMapping(value = {"out"})
    public void logout() {
        log.info("###logout:uid:{}\ntoken:{}", CurrentUtil.getCurrentUid(), CurrentUtil.getToken());

        redisUtil.del(jwtValidator.getSsoRedisKey().concat(CurrentUtil.getCurrentUid()));
    }

    @ApiOperationSupport(order = 7)
    @ApiOperation(value = "注销")
    @PostMapping(value = {"close"})
    public ResponseDto<Object> close() {
        log.info("###close:uid:{}", CurrentUtil.getCurrentUid());

        this.logout();

        adamUserService.close(CurrentUtil.getCurrentUid());

        return ResponseDto.success();
    }

    /* ---------------------------- Internal Method ---------------------------- */

    private boolean checkSmsCode(String mobile, String code) {
        if (Arrays.asList("dev", "test", "prod").contains(env.getProperty("spring.profiles.active")) && "111111".equals(code)) {
            return true;
        }

        LinkedMultiValueMap<String, String> paramsMap = new LinkedMultiValueMap<>();
        paramsMap.add("mobile", mobile);
        paramsMap.add("code", code);

        String respStr = null;
        try {
            respStr = HttpUtil.postToPhpApi(env.getProperty("liquidnet.url-service.url") + PHP_API_SMS_CODE_VALID, paramsMap);
            log.debug("###PHP.API[{}].RESP:{}", PHP_API_SMS_CODE_VALID, respStr);
            Map respMap = JsonUtils.fromJson(respStr, Map.class);
            if (!CollectionUtils.isEmpty(respMap) && StringUtils.equalsIgnoreCase("OK", (String) respMap.get("message"))) {
                return true;
            } else {
                log.warn("PHP.API验证码验证失败[mobile:{},code:{},respStr:{}]", mobile, code, respStr);
                return false;
            }
        } catch (Exception e) {
            log.error("PHP.API验证码验证异常[mobile:{},code:{},respStr:{}]", mobile, code, respStr, e);
            return false;
        }
    }

    private String getMobile(String accessToken) {
        try {
            GetMobileRequest request = new GetMobileRequest();
            request.setAccessToken(accessToken);

            GetMobileResponse response = defaultAcsClient.getAcsResponse(request);

            if (!Objects.isNull(response) && response.getCode().equalsIgnoreCase("OK")) {
                return response.getGetMobileResultDTO().getMobile();
            }
            log.warn("aliyun.dypns.api.response:{},{}", JsonUtils.toJson(response), accessToken);
        } catch (ClientException e) {
            log.error("aliyun.dypns.api:{}", accessToken, e);
        }
        return null;
    }

    private String ssoProcess(AdamUserInfoVo userInfoVo) {
        Map<String, Object> claimsMap = new HashMap<>();
        claimsMap.put("sub", userInfoVo.getUid());
        // TODO: 2021/5/25 修改手机号更新TOKEN
        claimsMap.put("mobile", userInfoVo.getMobile());
        claimsMap.put("nickname", userInfoVo.getNickname());
        claimsMap.put("type", "user");

        String token = jwtValidator.create(claimsMap);

        redisUtil.set(
                jwtValidator.getSsoRedisKey().concat(userInfoVo.getUid()),
                DigestUtils.md5DigestAsHex(token.getBytes(StandardCharsets.UTF_8)),
                jwtValidator.getExpireTtl() * 60
        );
        return token;
    }
}
