package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "AdamEntersResult", description = "入场人响应")
@Data
public class AdamEntersResult implements java.io.Serializable {
    private static final long serialVersionUID = 3219448286221952517L;
    @ApiModelProperty(position = 10, required = true, value = "入场人名称[50]", example = "测试")
    private String name;
    @ApiModelProperty(position = 11, required = true, value = "入场人手机号[11]", example = "13100000000")
    private String mobile;
    @ApiModelProperty(position = 12, required = true, value = "证件类型:1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证", allowableValues = "1,2,3,4,5")
    private Integer type;
    @ApiModelProperty(position = 13, required = true, value = "入场人证件号[11]", example = "110101110001010111")
    private String idCard;
    @ApiModelProperty(position = 14, required = true, value = "是否为默认:0-否,1-是", allowableValues = "0,1")
    private Boolean isDefault;
}
