package com.liquidnet.client.admin;

import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dto.vo.returns.KylinOrderRefundsVo;
import com.liquidnet.service.kylin.entity.KylinOrderRefunds;
import com.mongodb.BasicDBObject;
import com.mongodb.client.result.UpdateResult;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.time.LocalDateTime;

/**
 * Test
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestLocal {
    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    MongoConverter mongoConverter;

    @Test
    public void updateAt(){
        KylinOrderRefunds kylinOrderRefunds = new KylinOrderRefunds();
        kylinOrderRefunds.setStatus(KylinTableStatusConst.ORDER_REFUND_STATUS_APPLY);
        kylinOrderRefunds.setApplicantId("1111");
        kylinOrderRefunds.setApplicantName("2222");
        kylinOrderRefunds.setApplicantAt(LocalDateTime.now());
        KylinOrderRefundsVo kylinOrderRefundsVo = new KylinOrderRefundsVo();
        BeanUtils.copyProperties(kylinOrderRefunds, kylinOrderRefundsVo);
        kylinOrderRefundsVo.setUpdatedAt(LocalDateTime.now());
        BasicDBObject EntitiesVov = new BasicDBObject("$set", mongoConverter.convertToMongoType(kylinOrderRefundsVo));

        UpdateResult updateResult = mongoTemplate.getCollection(KylinOrderRefundsVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("orderRefundsId").in("2767295925071872949890")).getQueryObject(),
                EntitiesVov
        );
    }
}
