DROP TABLE IF EXISTS `sweet_performance_show`;
CREATE TABLE `sweet_performance_show`
(
    `mid`              bigint AUTO_INCREMENT,
    `ar_id`            varchar(64)      DEFAULT '' COMMENT '主键id',
    `performance_id`   varchar(255)     DEFAULT '' COMMENT '演出id',
    `performance_name` varchar(255)     DEFAULT '' COMMENT '演出名',
    `pic_one`          varchar(255)     DEFAULT '' COMMENT '图片1',
    `pic_two`          varchar(255)     DEFAULT '' COMMENT '图片2',
    `ar_url`           varchar(255)     DEFAULT '' COMMENT 'AR地址',
    `offline_url`      varchar(255)     DEFAULT '' COMMENT '离线地址',
    `time_start`       datetime         DEFAULT NULL COMMENT '开始时间',
    `time_end`         datetime         DEFAULT NULL COMMENT '结束时间',
    `status`           tinyint NOT NULL DEFAULT 0 COMMENT '状态 1可用 0不可用',
    PRIMARY KEY (`mid`) USING BTREE,
    KEY `sweet_performance_ar_id_index` (`ar_id`),
    KEY `sweet_performance_performance_name_index` (`performance_name`)
) ENGINE = InnoDB comment 'ar活动表';



DROP TABLE IF EXISTS `sweet_artists_url`;
CREATE TABLE `sweet_artists_url`
(
    `mid`        bigint       NOT NULL AUTO_INCREMENT,
    `artists_id` varchar(255) NOT NULL COMMENT 'artists_id',
    `url`        varchar(255) NULL DEFAULT NULL COMMENT 'url',
    `type`       varchar(255) NOT NULL COMMENT '类型1:图片 2：视频',
    `created_at` datetime     NULL DEFAULT NULL,
    PRIMARY KEY (`mid`) USING BTREE,
    KEY `sweet_artists_url_artists_id_index` (`artists_id`)
) ENGINE = InnoDB comment 'ar资源表';