package com.liquidnet.service.sweet.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaSubscribeMessage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.service.sweet.config.WechatMaConfigure;
import com.liquidnet.service.sweet.entity.SweetAppletSubMsg;
import com.liquidnet.service.sweet.mapper.SweetAppletSubMsgMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 小程序订阅消息记录表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-22
 */
@Service
@Slf4j
public class SweetAppletSubMsgSendServiceImpl {

    @Autowired
    private SweetAppletSubMsgMapper subMsgMapper;

    @Autowired
    WechatMaConfigure wechatMaConfigure;

    @Async
    public void toSend(List<SweetAppletSubMsg> msgList, String targetId, String title, String timeStart) {
        ArrayList<String> msgIdList = CollectionUtil.arrayListString();
        if (!CollectionUtils.isEmpty(msgList)) {
            for (SweetAppletSubMsg info : msgList) {
                try {
                    String msgId = info.getMsgId();
                    // 发送订阅消息接口
                    boolean subMessage = sendSubMessage(info, targetId, title, timeStart);
                    if (subMessage) {
                        msgIdList.add(msgId);
                    }
                } catch (Exception e) {
//                    log.error("小程序演出订阅提醒消息处理异常", e);
                }
            }
            if (!CollectionUtils.isEmpty(msgIdList)) {
                SweetAppletSubMsg update = new SweetAppletSubMsg();
                update.setIsPush(2);
                update.setUpdatedAt(LocalDateTime.now());
                subMsgMapper.update(
                        update,
                        Wrappers.lambdaUpdate(SweetAppletSubMsg.class)
                                .in(SweetAppletSubMsg::getMsgId, msgIdList)
                );
            }
        }
    }

    /**
     * 微信小程序推送订阅消息
     */
    private boolean sendSubMessage(SweetAppletSubMsg info, String performancesId, String title, String timeStart) {

        WxMaSubscribeMessage subscribeMessage = new WxMaSubscribeMessage();

        subscribeMessage.setPage("pages/webview?query=showdetails&id=".concat(performancesId));
        subscribeMessage.setTemplateId(info.getTemplateId());
        subscribeMessage.setToUser(info.getOpenId());

        ArrayList<WxMaSubscribeMessage.MsgData> wxMaSubscribeData = new ArrayList<>();
        WxMaSubscribeMessage.MsgData wxMaSubscribeData1 = new WxMaSubscribeMessage.MsgData();
        wxMaSubscribeData1.setName("thing1");
        wxMaSubscribeData1.setValue(title);
        //每个参数 存放到大集合中
        wxMaSubscribeData.add(wxMaSubscribeData1);

        // 第二个内容：用户昵称
        WxMaSubscribeMessage.MsgData wxMaSubscribeData2 = new WxMaSubscribeMessage.MsgData();
        wxMaSubscribeData2.setName("time2");
        wxMaSubscribeData2.setValue(timeStart);
        wxMaSubscribeData.add(wxMaSubscribeData2);

        // 第三个内容：领取方式
        WxMaSubscribeMessage.MsgData wxMaSubscribeData3 = new WxMaSubscribeMessage.MsgData();
        wxMaSubscribeData3.setName("thing3");
        wxMaSubscribeData3.setValue("您关注的演出活动门票即将开售，请准备购票");
        wxMaSubscribeData.add(wxMaSubscribeData3);

        subscribeMessage.setData(wxMaSubscribeData);
        try {
            //获取微信小程序配置：
            WxMaService wxService = wechatMaConfigure.getWxMaService(info.getAppletType());
            //进行推送
            wxService.getMsgService().sendSubscribeMsg(subscribeMessage);
            return true;
        } catch (Exception e) {
//            log.error("sendSubMessageException e{}", e);
        }
        return false;
    }
}
