package com.liquidnet.common.exception.properties;

import lombok.Data;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

@Data
public class ErrorCodeProperties {

    private static Properties properties;
    private static ErrorCodeProperties errorCodeProperties = new ErrorCodeProperties();
    static{
        reload();
    }
    public static void reload() {
        properties = new Properties();
        InputStream in = ErrorCodeProperties.class.getClassLoader()
                .getResourceAsStream("errorcode.properties");
        try {
            properties.load(in);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
    /**
     * 按key获取值
     * @param key
     * @return
     */
    public static String getValue(String key) {
        String value = "";
        if(properties != null){
            value = properties.getProperty(key);
        }
        return value;
    }

//    private ErrorCodeProperties() {
//        properties = new Properties();
//        InputStream in = ErrorCodeProperties.class.getClassLoader()
//                .getResourceAsStream("errorcode.properties");
//        try {
//            properties.load(in);
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//    }
//
//    public static ErrorCodeProperties getInstance() {
//        if (errorCodeProperties == null) {
//            errorCodeProperties = new ErrorCodeProperties();
//        }
//        return errorCodeProperties;
//    }
}
