package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetManualShop;
import com.liquidnet.service.sweet.entity.SweetManualShopMdsk;
import com.liquidnet.service.sweet.mapper.SweetManualShopMdskMapper;
import com.liquidnet.service.sweet.service.ISweetManualShopMdskService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.sweet.utils.RedisDataUtils;
import com.liquidnet.service.sweet.utils.RedisMDSKDataUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 电子宣传手册商铺表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-09
 */
@Service
public class SweetManualShopMdskServiceImpl extends ServiceImpl<SweetManualShopMdskMapper, SweetManualShopMdsk> implements ISweetManualShopMdskService {

    @Autowired
    private SweetManualShopMdskMapper sweetManualShopMdskMapper;
    @Autowired
    private RedisMDSKDataUtils redisDataUtils;

    @Override
    public ResponseDto<List<SweetManualShopMdsk>> getList(String manualId, Integer type) {
        try {
            List<SweetManualShopMdsk> data = sweetManualShopMdskMapper.selectList(Wrappers.lambdaQuery(SweetManualShopMdsk.class).eq(SweetManualShopMdsk::getManualId, manualId).eq(SweetManualShopMdsk::getType, type).eq(SweetManualShopMdsk::getStatus, 1));
            return ResponseDto.success(data);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<SweetManualShopMdsk> details(String manualShopId) {
        try {
            SweetManualShopMdsk data = sweetManualShopMdskMapper.selectOne(Wrappers.lambdaQuery(SweetManualShopMdsk.class).eq(SweetManualShopMdsk::getManualShopId, manualShopId).eq(SweetManualShopMdsk::getStatus, 1));
            return ResponseDto.success(data);
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId, String title, String picUrl, String describe, Integer type, Integer isRecommend, Integer sort) {
        try {
            SweetManualShopMdsk sweetManualShop = SweetManualShopMdsk.getNew();
            sweetManualShop.setManualShopId(IDGenerator.nextSnowId());
            sweetManualShop.setManualId(manualId);
            sweetManualShop.setTitle(title);
            sweetManualShop.setPicUrl(picUrl);
            sweetManualShop.setDescribes(describe);
            sweetManualShop.setType(type);
            sweetManualShop.setIsRecommend(isRecommend);
            sweetManualShop.setSort(sort);
            sweetManualShop.setStatus(1);
            sweetManualShopMdskMapper.insert(sweetManualShop);
            redisDataUtils.setManualShopRedisData(manualId);
            return ResponseDto.success();
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> change(String manualShopId,String manualId, String title, String picUrl, String describe, Integer type, Integer isRecommend, Integer sort) {
        try {
            SweetManualShopMdsk sweetManualShop = SweetManualShopMdsk.getNew();
            sweetManualShop.setTitle(title);
            sweetManualShop.setPicUrl(picUrl);
            sweetManualShop.setDescribes(describe);
            sweetManualShop.setType(type);
            sweetManualShop.setIsRecommend(isRecommend);
            sweetManualShop.setSort(sort);
            sweetManualShopMdskMapper.update(sweetManualShop, Wrappers.lambdaUpdate(SweetManualShopMdsk.class).eq(SweetManualShopMdsk::getManualShopId, manualShopId));
            redisDataUtils.setManualShopRedisData(manualId);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> delete(String manualShopId,String manualId) {
        try {
            SweetManualShopMdsk sweetManualShop = SweetManualShopMdsk.getNew();
            sweetManualShop.setStatus(0);
            sweetManualShopMdskMapper.update(sweetManualShop, Wrappers.lambdaUpdate(SweetManualShopMdsk.class).eq(SweetManualShopMdsk::getManualShopId, manualShopId));
            redisDataUtils.setManualShopRedisData(manualId);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

}
