package com.liquidnet.client.admin.zhengzai.adam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamMemberOrderAdminService;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.service.adam.dto.MemberOrderDto;
import com.liquidnet.service.adam.dto.param.admin.MemberOrderListReq;
import com.liquidnet.service.adam.dto.vo.AdamMemberOrderVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.dto.vo.AdamUserMemberVo;
import com.liquidnet.service.adam.dto.vo.admin.MemberOrderDetailAdminVo;
import com.liquidnet.service.adam.entity.AdamMemberOrder;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.entity.AdamUserInfo;
import com.liquidnet.service.adam.entity.AdamUserMember;
import com.liquidnet.service.adam.mapper.AdamMemberOrderMapper;
import com.liquidnet.service.adam.mapper.AdamUserInfoMapper;
import com.liquidnet.service.adam.mapper.AdamUserMapper;
import com.liquidnet.service.adam.mapper.AdamUserMemberMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: AdamMemberOrderAdminServiceImpl
 * @Package com.liquidnet.client.admin.zhengzai.adam.service.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/6/6 16:25
 */
@Service
public class AdamMemberOrderAdminServiceImpl extends ServiceImpl<AdamMemberOrderMapper, AdamMemberOrder> implements IAdamMemberOrderAdminService {
    @Autowired
    private AdamMemberOrderMapper adamMemberOrderMapper;
    @Autowired
    private AdamUserMemberMapper adamUserMemberMapper;
    @Autowired
    private AdamUserInfoMapper adamUserInfoMapper;
    @Autowired
    private AdamUserMapper adamUserMapper;

    @Override
    public List<MemberOrderDto> getMemberOrderList(MemberOrderListReq memberOrderListReq) {
        Map<String, Object> reqParamMap = new HashMap<>();
        try {
            reqParamMap = BeanUtil.convertBeanToMap(memberOrderListReq,false);
        } catch (IntrospectionException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        List<MemberOrderDto> list = adamMemberOrderMapper.getMemberOrderList(reqParamMap);
        return list;
    }

    @Override
    public MemberOrderDetailAdminVo getMemberOrderDetail(String orderNo) {
        MemberOrderDetailAdminVo detailAdminVo = new MemberOrderDetailAdminVo();
        AdamMemberOrderVo adamMemberOrderVo = new AdamMemberOrderVo();
        AdamUser adamUser = new AdamUser();
        AdamUserInfoVo adamUserInfoVo = new AdamUserInfoVo();
        AdamUserMemberVo adamUserMemberVo = new AdamUserMemberVo();

        LambdaQueryWrapper<AdamMemberOrder> queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(AdamMemberOrder::getOrderNo,orderNo);
        AdamMemberOrder adamMemberOrder = adamMemberOrderMapper.selectOne(queryWrapper);
        BeanUtil.copy(adamMemberOrder,adamMemberOrderVo);

        //获取用户会员信息
        LambdaQueryWrapper<AdamUserMember> adamUserMemberWrapper = new LambdaQueryWrapper();
        adamUserMemberWrapper.eq(AdamUserMember::getUid,adamMemberOrderVo.getUid());
        AdamUserMember adamUserMember = adamUserMemberMapper.selectOne(adamUserMemberWrapper);
        BeanUtil.copy(adamUserMember,adamUserMemberVo);
        //获取用户信息表
        LambdaQueryWrapper<AdamUserInfo> adamUserInfoWrapper = new LambdaQueryWrapper();
        adamUserInfoWrapper.eq(AdamUserInfo::getUid,adamMemberOrderVo.getUid());
        AdamUserInfo adamUserInfo = adamUserInfoMapper.selectOne(adamUserInfoWrapper);
        BeanUtil.copy(adamUserInfo,adamUserInfoVo);
        //获取用户表信息
        LambdaQueryWrapper<AdamUser> adamUserWrapper = new LambdaQueryWrapper();
        adamUserWrapper.eq(AdamUser::getUid,adamMemberOrderVo.getUid());
        adamUser = adamUserMapper.selectOne(adamUserWrapper);

        detailAdminVo.setAdamMemberOrderVo(adamMemberOrderVo);
        detailAdminVo.setAdamUserMemberVo(adamUserMemberVo);
        detailAdminVo.setAdamUserInfoVo(adamUserInfoVo);
        detailAdminVo.setAdamUser(adamUser);
        return detailAdminVo;
    }
}
