package com.liquidnet.service.galaxy.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.aop.annotation.ControllerLog;
import com.liquidnet.service.galaxy.dto.param.GalaxyQueryNftListReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyQueryNftListRespDto;
import com.liquidnet.service.galaxy.service.IGalaxyTradeQueryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyTradeQueryController
 * @Package com.liquidnet.service.galaxy.controller
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/7 16:12
 */
@Api(tags = "NFT交易查询相关")
@RestController
@RequestMapping("nftTradeQuery")
@Validated
@Slf4j
public class GalaxyTradeQueryController {
    @Resource(name = "galaxyTradeQueryService")
    private IGalaxyTradeQueryService galaxyTradeQueryService;

    @ControllerLog(description = "NFT列表查询")
    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "NFT列表查询")
    @PostMapping(value = {"nftList"})
    public ResponseDto<GalaxyQueryNftListRespDto> nftList(@Valid @RequestBody GalaxyQueryNftListReqDto reqDto){
        return galaxyTradeQueryService.nftList(reqDto);
    }
}
