package com.liquidnet.service.galaxy.router.zxin.service;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;
import com.liquidnet.service.galaxy.dto.param.GalaxyQueryNftListReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyQueryNftListRespDto;
import com.liquidnet.service.galaxy.router.strategy.IGalaxyRouterStrategyTradeQuery;
import com.liquidnet.service.galaxy.router.strategy.annotation.StrategyGalaxyRouterTradeQueryHandler;
import com.liquidnet.service.galaxy.router.zxin.biz.ZxinTradeQueryBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: PayChannelStrategyAlipayImpl
 * @Package com.liquidnet.service.dragon.channel.strategy.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/4/7 13:06
 */
@Slf4j
@Component
@StrategyGalaxyRouterTradeQueryHandler(GalaxyEnum.RouterTypeEnum.ZXINCHAIN)
public class GalaxyRouterStrategyZxlTradeQueryImpl implements IGalaxyRouterStrategyTradeQuery {
    @Autowired
    private ZxinTradeQueryBiz zxinTradeQueryBiz;

    @Override
    public ResponseDto<GalaxyQueryNftListRespDto> nftList(GalaxyQueryNftListReqDto reqDto) {
        return zxinTradeQueryBiz.nftList(reqDto);
    }
}
