package com.liquidnet.service.zxlnft.test;

import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.dto.wallet.CreateMnemonicReq;
import com.liquidnet.common.third.zxlnft.dto.wallet.GenerateApiSignReq;
import com.liquidnet.common.third.zxlnft.dto.wallet.SignByPriKeyReq;
import com.liquidnet.common.third.zxlnft.dto.wallet.VerifyByPubKeyReq;
import com.liquidnet.common.third.zxlnft.util.ZxlnftSdkUtil;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestZxlnftSdkUtil
 * @Package com.liquidnet.common.third.zxlnft.test
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 13:49
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestZxlWalletSdkUtil {
    @Autowired
    private ZxlnftSdkUtil zxlnftSdkUtil;

    @Autowired
    private ZxlnftConfig zxlnftConfig;

    @Test
    public void createMnemonic(){
        CreateMnemonicReq req = CreateMnemonicReq.getNew();
        zxlnftSdkUtil.createMnemonic(req);
    }

    @Test
    public void generateApiSign(){
        GenerateApiSignReq req = GenerateApiSignReq.getNew();
        req.setAppId("");
        req.setAppKey("");
        zxlnftSdkUtil.generateApiSign(req);
    }

    @Test
    public void signByPriKey(){
        SignByPriKeyReq req = SignByPriKeyReq.getNew();
//        req.setPriKey(zxlnftConfig.getNftPlatformPriKey());
        req.setPriKey(zxlnftConfig.getNftPlatformPriKey());
        req.setData("ZXa66c8a684727d0f9aaa434044362aa8a18b61bb4");
        //3045022072ba19d02f43ae883764ffa43d111ab62fd0bcd6ace31bc91356e7ce38756cbb022100deb5f7666f4768f297ccdf386a867d2a0d71227548f2595a62130e5016fb1d54
        zxlnftSdkUtil.signByPriKey(req);
    }

    @Test
    public void verifyByPubKey(){
        VerifyByPubKeyReq req = VerifyByPubKeyReq.getNew();
        req.setPubKey(zxlnftConfig.getNftPlatformPubKey());
        req.setData("ZXa66c8a684727d0f9aaa434044362aa8a18b61bb4-");
        req.setSignedData("3045022072ba19d02f43ae883764ffa43d111ab62fd0bcd6ace31bc91356e7ce38756cbb022100deb5f7666f4768f297ccdf386a867d2a0d71227548f2595a62130e5016fb1d54");
        //3045022072ba19d02f43ae883764ffa43d111ab62fd0bcd6ace31bc91356e7ce38756cbb022100deb5f7666f4768f297ccdf386a867d2a0d71227548f2595a62130e5016fb1d54
        zxlnftSdkUtil.verifyByPubKey(req);
    }
}
