package com.liquidnet.client.admin.zhengzai.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetIntegralActivityDrawService;
import com.liquidnet.client.admin.zhengzai.sweet.utils.SweetRedisAdminUtils;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.sweet.dto.SweetActivityDrawListDao;
import com.liquidnet.service.sweet.dto.admin.SweetIntegralActivityDrawListSearchParam;
import com.liquidnet.service.sweet.dto.vo.IntegralActivityDrawVo;
import com.liquidnet.service.sweet.entity.SweetIntegralActivityDraw;
import com.liquidnet.service.sweet.mapper.SweetIntegralActivityDrawMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.sweet.utils.SweetNewObjectUtil;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 积分活动抽奖记录表 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-22
 */
@Service
public class SweetIntegralActivityDrawServiceImpl extends ServiceImpl<SweetIntegralActivityDrawMapper, SweetIntegralActivityDraw> implements ISweetIntegralActivityDrawService {

    @Autowired
    private SweetIntegralActivityDrawMapper sweetIntegralActivityDrawMapper;

    @Autowired
    private SweetRedisAdminUtils sweetRedisAdminUtils;

    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public PageInfo<SweetActivityDrawListDao> drawList(SweetIntegralActivityDrawListSearchParam listParam) {
        /*PageHelper.startPage(listParam.getPageNum(), listParam.getPageSize());
        LambdaQueryWrapper<SweetIntegralActivityDraw> queryWrapper = Wrappers.lambdaQuery(SweetIntegralActivityDraw.class)
                .eq(SweetIntegralActivityDraw::getIntegralActivityId, listParam.getIntegralActivityId());
        if (!listParam.getNickname().isEmpty()) {
            queryWrapper.like(SweetIntegralActivityDraw::getNickname, listParam.getNickname());
        }
        if (!listParam.getPrizeTitle().isEmpty()) {
            queryWrapper.like(SweetIntegralActivityDraw::getPrizeTitle, listParam.getPrizeTitle());
        }
        Integer prizeType = listParam.getPrizeType();
        if (null != prizeType && prizeType > 0) {
            queryWrapper.like(SweetIntegralActivityDraw::getPrizeType, prizeType);
        }
        Integer receivingStatus = listParam.getReceivingStatus();
        if (null != receivingStatus && receivingStatus > 0) {
            queryWrapper.like(SweetIntegralActivityDraw::getReceivingStatus, receivingStatus);
        }
        Integer isWin = listParam.getIsWin();
        if (null != isWin && isWin > 0) {
            if (isWin == 1) {
                queryWrapper.eq(SweetIntegralActivityDraw::getPrizeType, 1);
            } else if (isWin == 2) {
                queryWrapper.ne(SweetIntegralActivityDraw::getPrizeType, 1);
            }
        }
        List<SweetIntegralActivityDraw> sweetIntegralActivityDraws = sweetIntegralActivityDrawMapper.selectList(
                queryWrapper
        );*/
        try {
            PageHelper.startPage(listParam.getPageNum(), listParam.getPageSize());
            List<SweetActivityDrawListDao> lists = sweetIntegralActivityDrawMapper.searchLists(listParam);
            return new PageInfo(lists);
        } catch (Exception e) {
            return new PageInfo();
        }
    }

    @Override
    public List<SweetActivityDrawListDao> selectExcelList(String integralActivityId) {
        List<SweetActivityDrawListDao> sweetIntegralActivityDraws = sweetIntegralActivityDrawMapper.selectExcelList(integralActivityId);
        return sweetIntegralActivityDraws;
    }

    @Override
    public Integer receivingStatus(String drawId) {
        SweetIntegralActivityDraw sweetIntegralActivityDraw = SweetIntegralActivityDraw.getNew();
        sweetIntegralActivityDraw.setReceivingStatus(2);
        sweetIntegralActivityDraw.setUpdatedAt(LocalDateTime.now());
        int update = sweetIntegralActivityDrawMapper.update(
                sweetIntegralActivityDraw,
                Wrappers.lambdaUpdate(SweetIntegralActivityDraw.class).eq(SweetIntegralActivityDraw::getDrawId, drawId)
        );
        SweetIntegralActivityDraw sweetIntegralActivityDrawNew = sweetIntegralActivityDrawMapper.selectOne(
                Wrappers.lambdaUpdate(SweetIntegralActivityDraw.class).eq(SweetIntegralActivityDraw::getDrawId, drawId)
        );

        // 更新缓存
        sweetRedisAdminUtils.delIntegralActivityDrawList(sweetIntegralActivityDrawNew.getIntegralActivityId(), sweetIntegralActivityDrawNew.getUserId());

        sweetRedisAdminUtils.setIntegralActivityDrawInfo(drawId);

        mongoTemplate.getCollection(IntegralActivityDrawVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("drawId").is(drawId)).getQueryObject(),
                new Document("$set", new Document("receivingStatus", 2)
                        .append("updatedAt", LocalDateTime.now()))
        );

        return update;
    }

}
