package com.liquidnet.client.admin.web.controller.zhengzai.sweet;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetAdminActiveTypeService;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetAdminQrCodeService;
import com.liquidnet.client.admin.zhengzai.sweet.service.ISweetIntegralActivityService;
import com.liquidnet.service.kylin.dao.PerformanceTitleDao;
import com.liquidnet.service.kylin.dao.RoadShowAdminListDao;
import com.liquidnet.service.kylin.dto.param.CreateActiveQrCodeParam;
import com.liquidnet.service.kylin.dto.param.CreateActiveTypeParam;
import com.liquidnet.service.kylin.dto.param.CreateRoadShowParam;
import com.liquidnet.service.kylin.dto.vo.admin.KylinRoadShowAdminVo;
import com.liquidnet.service.kylin.service.admin.IKylinRoadShowsAdminService;
import com.liquidnet.service.sweet.dto.SweetIntegralActivityDto;
import com.liquidnet.service.sweet.dto.param.admin.SweetIntegralActivityFromParam;
import com.liquidnet.service.sweet.dto.param.admin.SweetIntegralActivityListSearchParam;
import com.liquidnet.service.sweet.dto.vo.admin.SweetIntegralActivityVo;
import com.liquidnet.service.sweet.entity.SweetActiveType;
import com.liquidnet.service.sweet.entity.SweetQrCode;
import com.liquidnet.service.sweet.service.ISweetActiveTypeService;
import com.liquidnet.service.sweet.service.ISweetQrCodeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * <p>
 * 活动二维码 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */
@Api(tags = "活动二维码")
@Controller
@RequestMapping("sweet/active")
public class SweetActiveController extends BaseController {
    private String prefix = "zhengzai/sweet/qrCode";

    @Value("${liquidnet.client.admin.platformUrl}")
    private String platformUrl;


    @Autowired
    private ISweetAdminActiveTypeService sweetAdminActiveTypeService;
    @Autowired
    private ISweetAdminQrCodeService sweetAdminQrCodeService;

    @GetMapping("qrcode")
    public String qrcode(ModelMap mmap) {
        return prefix + "/qrcode";
    }

    @Log(title = "二维码列表管理", businessType = BusinessType.LIST)
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo getList(@RequestParam(value = "pageNum") int page,
                                 @RequestParam(value = "pageSize") int size) {
        startPage();
        List<SweetActiveType> result = sweetAdminActiveTypeService.getList(page, size);
        return getDataTable(result);
    }

    /**
     * 新增类型
     */
    @GetMapping("/add")
    public String add() {
        return prefix + "/add";
    }

    @Log(title = "二维码列表管理", businessType = BusinessType.INSERT)
    @PostMapping("/add")
    @ResponseBody
    public AjaxResult createType(CreateActiveTypeParam createActiveTypeParam) {
        return toAjax(sweetAdminActiveTypeService.addInfo(createActiveTypeParam));
    }

    //    @RequiresPermissions("kylin:performances:roadShow:details")
    @Log(title = "二维码列表管理", businessType = BusinessType.DETAIL)
    @GetMapping(value = "/details/{mid}")
    public String detailsType(@PathVariable("mid") String mid, ModelMap mmap) {
        SweetActiveType result = sweetAdminActiveTypeService.details(mid);
        mmap.put("SweetActiveType", result);
        return prefix + "/edit";
    }

    //    @RequiresPermissions("kylin:performances:roadShow:edit")
    @Log(title = "二维码列表管理", businessType = BusinessType.UPDATE)
    @PostMapping("/edit")
    @ResponseBody
    public AjaxResult updateType(CreateActiveTypeParam createActiveTypeParam) {
        return toAjax(sweetAdminActiveTypeService.changeInfo(createActiveTypeParam));
    }

    @Log(title = "二维码列表管理", businessType = BusinessType.DETAIL)
    @GetMapping("/detailsList/{type}")
    public String addPerformance(@PathVariable("type") String type, ModelMap mmap) {
        mmap.put("type", type);
        return prefix + "/details";
    }


    @GetMapping(value = "/qrCode/{type}")
    @ResponseBody
    public TableDataInfo listBymId(@PathVariable("type") String type) {
        List<SweetQrCode> result = sweetAdminQrCodeService.getList(type);
        return getDataTable(result);
    }

    /**
     * 新增类型
     */
    @GetMapping("/addQrCode/{type}")
    public String addQrCode(@PathVariable("type") String type, ModelMap mmap) {
        mmap.put("type", type);
        mmap.put("platformUrl", platformUrl);
        return prefix + "/addQrCode";
    }

    @Log(title = "二维码列表管理", businessType = BusinessType.INSERT)
    @PostMapping("/addQrCode")
    @ResponseBody
    public AjaxResult createQrCode(CreateActiveQrCodeParam createActiveTypeParam) {
        return toAjax(sweetAdminQrCodeService.addQrCode(createActiveTypeParam));
    }

    @Log(title = "二维码列表管理", businessType = BusinessType.DETAIL)
    @GetMapping(value = "/editQrCode/{mid}")
    public String editDetails(@PathVariable("mid") String mid, ModelMap mmap) {
        SweetQrCode result = sweetAdminQrCodeService.details(mid);
        mmap.put("SweetQrCode", result);
        return prefix + "/editQrCode";
    }

    @Log(title = "二维码列表管理", businessType = BusinessType.UPDATE)
    @PostMapping("/editQrCode")
    @ResponseBody
    public AjaxResult updateType(CreateActiveQrCodeParam createActiveTypeParam) {
        return toAjax(sweetAdminQrCodeService.changeInfo(createActiveTypeParam));
    }
}
