/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.channel.embedded;

import com.taobao.api.internal.toplink.Logger;
import com.taobao.api.internal.toplink.LoggerFactory;
import com.taobao.api.internal.toplink.Text;
import com.taobao.api.internal.toplink.channel.ChannelException;
import com.taobao.api.internal.toplink.channel.ClientChannel;
import com.taobao.api.internal.toplink.channel.embedded.EmbeddedWebSocketClientChannel;
import com.taobao.api.internal.toplink.channel.embedded.EmbeddedWebSocketHandler;
import com.taobao.api.internal.toplink.channel.websocket.WebSocketClientHelper;
import com.taobao.api.internal.toplink.embedded.websocket.WebSocket;
import com.taobao.api.internal.toplink.embedded.websocket.WebSockets;
import com.taobao.api.internal.toplink.embedded.websocket.impl.WebSocketBase;
import com.taobao.api.internal.toplink.embedded.websocket.impl.WebSocketImpl;
import java.net.URI;
import java.util.Map;

public class EmbeddedWebSocketClient {
    private static final String[] subprotocol = new String[0];

    public static ClientChannel connect(LoggerFactory loggerFactory, URI uri, int timeout) throws ChannelException {
        EmbeddedWebSocketClient.resetSettings();
        Logger logger = loggerFactory.create(String.format("EmbeddedWebSocketHandler-%s", uri));
        EmbeddedWebSocketClientChannel clientChannel = new EmbeddedWebSocketClientChannel();
        clientChannel.setUri(uri);
        try {
            WebSocket socket = WebSockets.create(uri.toASCIIString(), new EmbeddedWebSocketHandler(logger, clientChannel), subprotocol);
            ((WebSocketBase)socket).setPacketDumpMode(0);
            socket.setBlockingMode(false);
            socket.setConnectionTimeout(timeout / 1000);
            Map<String, String> headers = WebSocketClientHelper.getHeaders(uri);
            if (headers != null) {
                for (String h : headers.keySet()) {
                    ((WebSocketImpl)socket).getRequestHeader().addHeader(h, headers.get(h));
                }
            }
            socket.connect();
        }
        catch (Exception e) {
            throw new ChannelException(Text.CONNECT_ERROR, e);
        }
        if (clientChannel.error != null) {
            throw new ChannelException(Text.WS_HANDSHAKE_ERROR, clientChannel.error);
        }
        return clientChannel;
    }

    private static void resetSettings() {
        System.setProperty("websocket.upstreamQueueSize", "10000");
        System.setProperty("websocket.packatdump", "0");
    }
}

