package com.liquidnet.common.third.antchain.constant;

import java.util.Arrays;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ErrorEnum
 * @Package com.liquidnet.common.third.antchain.constant
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/21 14:00
 *
 *  * SYS001[0001~9999] : 系统占用  SYS0010001
 *  * ZXL001[0001~9999] : 至信链NFT业务
 *  说明 ZXL001为NFT业务  ZXL002为存证业务
 */
public enum AntchainErrorEnum {
    SECCESS("0","成功"),
    FAILURE("1","失败"),
    SYSTEM_ERROR("SYS0010001", "系统异常，请联系管理员"),
    SERVER_INNER_ERROR("SYS0010002", "系统内部错误"),
    SERVER_ERROR("SYS0010003", "服务不可用,调用后端服务失败"),
    INVALID_PARAM_ERROR("ZXL0010001", "参数错误"),
    GENERATE_KEYPAIR_ERROR("ZXL0010002", "生成公私钥错误"),
    SIGN_ERROR("ZXL0010003", "签名错误"),
    VERIFY_ERROR("ZXL0010004", "验签错误"),
    ENCRYPT_ERROR("ZXL0010005", "加密数据错误"),
    DECODE_ERROR("ZXL0010006", "解密数据错误"),
    IMAGE_CHECK_ERROR("ZXL0010007", "图片内容检测未通过"),
    PARAM_FORMAT_ERROR("ZXL0010008", "参数格式错误"),
    ORDER_NOT_FOUND_ERROR("ZXL0010009", "此编号未查到对应信息"),
    UPLOAD_TEMP_SECRET("ZXL0010010", "生成素材上传临时密钥失败");
    private String code;
    private String msg;
    AntchainErrorEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }
    public String getCode() { return this.code; }
    public String getMsg() { return this.msg; }
    public static String errorMsg(String content) {
        AntchainErrorEnum err = Arrays.<AntchainErrorEnum>asList(values()).stream().filter(errorEnum -> errorEnum.getCode().equals(content)).findFirst().orElse(SERVER_INNER_ERROR);
        return err.getMsg();
    }
}