package com.liquidnet.common.third.xuper.dto;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 获取访问BOS临时STS凭证
 * @class: Xuper001GetStokenRespDto
 * @Package com.liquidnet.common.third.xuper.dto
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/18 15:10
 */
@Data
public class Xuper001GetStokenRespDto {
    /**
     * 后端生成，用于问题反馈，建议业务日志纪录
     */
    public long requestId;
    /**
     * 错误码 0为成功，其他可参考常用错误码
     */
    public int errNo;
    /**
     * 错误信息
     */
    public String errMsg;
    /**
     * 获取的临时授权的bos信息
     */
    public AccessInfo accessInfo;

    @Data
    public static class AccessInfo {
        /**
         * 存储空间
         */
        @JSONField(
                name = "bucket"
        )
        public String bucket;

        /**
         * 访问域名
         */
        @JSONField(
                name = "endpoint"
        )
        public String endpoint;

        /**
         * 文件路径
         */
        @JSONField(
                name = "object_path"
        )
        public String objectPath;

        /**
         * 访问密钥公钥
         */
        @JSONField(
                name = "access_key_id"
        )
        public String accessKeyId;

        /**
         * 访问密钥私钥
         */
        @JSONField(
                name = "secret_access_key"
        )
        public String secretAccessKey;

        /**
         * 临时有权的token，有效期为30min
         */
        @JSONField(
                name = "session_token"
        )
        public String sessionToken;

        /**
         * 鉴权生效开始时间
         */
        @JSONField(
                name = "createTime"
        )
        public LocalDateTime createTime;

        /**
         * 鉴权失效时间
         */
        @JSONField(
                name = "expiration"
        )
        public LocalDateTime expiration;
    }

    private static final Xuper001GetStokenRespDto obj = new Xuper001GetStokenRespDto();
    public static Xuper001GetStokenRespDto getNew() {
        try {
            return (Xuper001GetStokenRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Xuper001GetStokenRespDto();
        }
    }
}
