package com.liquidnet.common.third.zxlnft.dto;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 23.申请积分
 * @class: PointApplyReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:38
 */
@Data
public class Nft023PointApplyReqDto implements Serializable {
    /**
     * 申请对象地址
     */
    private String applyerAddr;
    /**
     * 平台公钥
     */
    private String platformPubKey;
    /**
     * 积分数量
     */
    private Long count;
    /**
     * 请求ID，每个请求需要填唯一的ID，重复请求用相同的ID
     */
    private String operateId;
    /**
     * 平台方的私钥签名，签名对象和signature对象一致，签名对象是(platformPubKey_applyerAddr_接口名_count_operateId)  接口名=apply_point
     */
    private String platformSignature;

    private static final Nft023PointApplyReqDto obj = new Nft023PointApplyReqDto();
    private static final long serialVersionUID = 1501517235847263377L;

    public static Nft023PointApplyReqDto getNew() {
        try {
            return (Nft023PointApplyReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft023PointApplyReqDto();
        }
    }
}
