package com.liquidnet.service.smile.entity.dto;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 志愿者-志愿者项目表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-04-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SmileVolunteersProjectListDto implements Serializable, Cloneable {

    private static final long serialVersionUID = 1L;

    /**
     * 活动id
     */
    private String projectId;

    /**
     * 项目名称
     */
    private String title;

    /**
     * 开始时间
     */
    private LocalDateTime timeStart;

    /**
     * 结束时间
     */
    private LocalDateTime timeEnd;

    /**
     * 状态[1-上线|0-下线]
     */
    private Integer status;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 活动状态 [1开始|2结束]
     */
    private Integer timeStatus;
    /**
     * 报名人数
     */
    private Integer all;

    /**
     * 待审核人数
     */
    private Integer unAudit;

    /**
     * 审核人数
     */
    private Integer audit;

    /**
     * 拒绝人数
     */
    private Integer refuse;

    private static final SmileVolunteersProjectListDto obj = new SmileVolunteersProjectListDto();

    public static SmileVolunteersProjectListDto getNew() {
        try {
            return (SmileVolunteersProjectListDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SmileVolunteersProjectListDto();
        }
    }
}
