package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 电子宣传手册艺人表
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetManualArtists implements Serializable ,Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * manual_relation_id
     */
    private String manualRelationId;

    /**
     * 电子宣传手册id
     */
    private String manualId;

    /**
     * 关联id
     */
    private String stageId;

    /**
     * 关联id
     */
    private String artistsId;

    /**
     * 演出开始时间
     */
    private LocalDateTime performanceStart;

    /**
     * 演出结束时间
     */
    private LocalDateTime performanceEnd;

    /**
     * 签收开始时间
     */
    private LocalDateTime signatureStart;

    /**
     * 签收结束时间
     */
    private LocalDateTime signatureEnd;

    /**
     * 0关闭 1开启
     */
    private Integer status;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetManualArtists obj = new SweetManualArtists();
    public static SweetManualArtists getNew() {
        try {
            return (SweetManualArtists) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetManualArtists();
        }
    }
}
