package com.liquidnet.service.sweet.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel
public class SweetManualArtistListFiveDto implements Serializable,Cloneable {
    private static final long serialVersionUID = 8382714055996962257L;
    @ApiModelProperty("电子手册关联id")
    private String manualRelationId;
    @ApiModelProperty("艺人id")
    private String artistId;
    @ApiModelProperty("艺人名称")
    private String name;
    @ApiModelProperty("拼音")
    private String pinyin;
    @ApiModelProperty("简介")
    private String describes;
    @ApiModelProperty("头像图片")
    private String picUrl;
    @ApiModelProperty("舞台id")
    private String stageId;
    @ApiModelProperty("舞台名称")
    private String title;
    @ApiModelProperty("演出开始")
    private String performanceStart;
    @ApiModelProperty("演出结束")
    private String performanceEnd;
    @ApiModelProperty("签售开始")
    private String signatureStart;
    @ApiModelProperty("签售结束")
    private String signatureEnd;

    @ApiModelProperty("是否观看")
    private Integer isWatch;
    @ApiModelProperty("是否登记")
    private Integer isSign;

    private static final SweetManualArtistListFiveDto obj = new SweetManualArtistListFiveDto();
    public static SweetManualArtistListFiveDto getNew() {
        try {
            return (SweetManualArtistListFiveDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetManualArtistListFiveDto();
        }
    }
}
