package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 积分活动奖品表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetIntegralActivityPrize implements Serializable, Cloneable {

    private static final long serialVersionUID = -3723467937911946082L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 奖品id
     */
    private String prizeId;

    /**
     * 关联活动id
     */
    private String integralActivityId;

    /**
     * 奖品名称
     */
    private String prizeTitle;

    /**
     * 奖品描述
     */
    private String prizeDescribe;

    /**
     * 初始展示奖品图片
     */
    private String prizeImgInit;

    /**
     * 中奖选中奖品图片
     */
    private String prizeImgSelect;

    /**
     * 奖品类型 1积分 2优惠券 3实物 4登登登VIP
     */
    private Integer prizeType;

    /**
     * 单次奖励数量如积分 中奖给多少物
     */
    private Integer prizeTypeNum;

    /**
     * 奖品数量
     */
    private Integer prizeNum;

    /**
     * 是否是无限库存 1有限库存 2无限
     */
    private Integer isInfinite;

    /**
     * 中奖概率
     */
    private BigDecimal winningProbability;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetIntegralActivityPrize obj = new SweetIntegralActivityPrize();

    public static SweetIntegralActivityPrize getNew() {
        try {
            return (SweetIntegralActivityPrize) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetIntegralActivityPrize();
        }
    }

}
