package com.liquidnet.service.galaxy.biz;

import com.liquidnet.common.third.antchain.constant.AntchainEnum;
import com.liquidnet.common.third.xuper.constant.XuperEnum;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftEnum;
import com.liquidnet.service.galaxy.constant.GalaxyEnum;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyConstantBiz
 * @Package com.liquidnet.service.galaxy.router.strategy
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/3/22 12:11
 */
public class GalaxyEnumBiz {

    /**
     * 任务状态转换（至信链通用状态 百度链为系列声明状态转换）
     * @param routerType
     * @param code
     * @return
     */
    public static GalaxyEnum.TaskStatusEnum getTaskStatusEnum(String routerType, String code){
        GalaxyEnum.TaskStatusEnum taskStatusEnum = null;
        switch (routerType){
            case "zxinchain":
                if(code.equalsIgnoreCase(ZxlnftEnum.TaskStatusEnum.PROCESSING.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.PROCESSING;
                    break;
                }else if(code.equalsIgnoreCase(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.TASK_SUCCESS;
                    break;
                }else if(code.equalsIgnoreCase(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.TASK_FAIL;
                    break;
                }
            case "antchain":
                if(code.equalsIgnoreCase(AntchainEnum.TaskStatusEnum.PROCESSING.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.PROCESSING;
                    break;
                }else if(code.equalsIgnoreCase(AntchainEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.TASK_SUCCESS;
                    break;
                }else if(code.equalsIgnoreCase(AntchainEnum.TaskStatusEnum.TASK_FAIL.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.TASK_FAIL;
                    break;
                }
            case "xuper":
                if(code.equalsIgnoreCase(XuperEnum.AssetPublishStatusEnum.INIT.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.TASK_SUCCESS;
                    break;
                }{
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.TASK_FAIL;
                    break;
                }
        }
        return taskStatusEnum;
    }


    /**
     * 任务状态转换
     * @param routerType
     * @param code
     * @return
     */
    public static GalaxyEnum.AssetPublishStatusEnum getAssetPublishStatusEnum(String routerType, String code){
        GalaxyEnum.AssetPublishStatusEnum taskStatusEnum = null;
        switch (routerType){
            case "xuper":
                if(code.equalsIgnoreCase(XuperEnum.AssetPublishStatusEnum.INIT.getCode())){
                    taskStatusEnum = GalaxyEnum.AssetPublishStatusEnum.INIT;
                    break;
                }else if(code.equalsIgnoreCase(XuperEnum.AssetPublishStatusEnum.PUBLISHING.getCode())){
                    taskStatusEnum = GalaxyEnum.AssetPublishStatusEnum.PROCESSING;
                    break;
                }else if(code.equalsIgnoreCase(XuperEnum.AssetPublishStatusEnum.PUBLISH_SUCCESS.getCode())){
                    taskStatusEnum = GalaxyEnum.AssetPublishStatusEnum.SUCCESS;
                    break;
                }else if(code.equalsIgnoreCase(XuperEnum.AssetPublishStatusEnum.FREEZING.getCode())
                        ||code.equalsIgnoreCase(XuperEnum.AssetPublishStatusEnum.BANNEDING.getCode())
                        ||code.equalsIgnoreCase(XuperEnum.AssetPublishStatusEnum.BANNEDED.getCode())
                ){
                    taskStatusEnum = GalaxyEnum.AssetPublishStatusEnum.FAIL;
                    break;
                }
        }
        return taskStatusEnum;
    }

    /**
     * 用户绑定状态
     * @param routerType
     * @param code
     * @return
     */
    public static GalaxyEnum.UserBindStatusEnum getUserBindStatusEnum(String routerType, String code) {
        GalaxyEnum.UserBindStatusEnum userBindStatusEnum = null;
        switch (routerType) {
            case "zxinchain":
                if (code.equalsIgnoreCase(ZxlnftEnum.UserBindStatusEnum.BIND_PROCESSING.getCode())) {
                    userBindStatusEnum = GalaxyEnum.UserBindStatusEnum.BIND_PROCESSING;
                    break;
                } else if (code.equalsIgnoreCase(ZxlnftEnum.UserBindStatusEnum.BIND_SUCCESS.getCode())) {
                    userBindStatusEnum = GalaxyEnum.UserBindStatusEnum.BIND_SUCCESS;
                    break;
                } else if (code.equalsIgnoreCase(ZxlnftEnum.UserBindStatusEnum.BIND_FAIL.getCode())) {
                    userBindStatusEnum = GalaxyEnum.UserBindStatusEnum.BIND_FAIL;
                    break;
                } else if (code.equalsIgnoreCase(ZxlnftEnum.UserBindStatusEnum.BIND_CANNOT_QUERY.getCode())) {
                    userBindStatusEnum = GalaxyEnum.UserBindStatusEnum.BIND_CANNOT_QUERY;
                    break;
                }
            case "antchain":
                if (code.equalsIgnoreCase(AntchainEnum.UserBindStatusEnum.BIND_PROCESSING.getCode())) {
                    userBindStatusEnum = GalaxyEnum.UserBindStatusEnum.BIND_PROCESSING;
                    break;
                } else if (code.equalsIgnoreCase(AntchainEnum.UserBindStatusEnum.BIND_SUCCESS.getCode())) {
                    userBindStatusEnum = GalaxyEnum.UserBindStatusEnum.BIND_SUCCESS;
                    break;
                } else if (code.equalsIgnoreCase(AntchainEnum.UserBindStatusEnum.BIND_FAIL.getCode())) {
                    userBindStatusEnum = GalaxyEnum.UserBindStatusEnum.BIND_FAIL;
                    break;
                } else if (code.equalsIgnoreCase(AntchainEnum.UserBindStatusEnum.BIND_CANNOT_QUERY.getCode())) {
                    userBindStatusEnum = GalaxyEnum.UserBindStatusEnum.BIND_CANNOT_QUERY;
                    break;
                }
        }
        return userBindStatusEnum;
    }

    /**
     * 资产授予状态转换
     * @param routerType
     * @param code
     * @return
     */
    public static GalaxyEnum.TaskStatusEnum getGrantStatusEnum(String routerType, String code){
        GalaxyEnum.TaskStatusEnum taskStatusEnum = null;
        switch (routerType){
            case "zxinchain":
                if(code.equalsIgnoreCase(ZxlnftEnum.TaskStatusEnum.PROCESSING.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.PROCESSING;
                    break;
                }else if(code.equalsIgnoreCase(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.TASK_SUCCESS;
                    break;
                }else if(code.equalsIgnoreCase(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.TASK_FAIL;
                    break;
                }
            case "antchain":
                if(code.equalsIgnoreCase(AntchainEnum.TaskStatusEnum.PROCESSING.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.PROCESSING;
                    break;
                }else if(code.equalsIgnoreCase(AntchainEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.TASK_SUCCESS;
                    break;
                }else if(code.equalsIgnoreCase(AntchainEnum.TaskStatusEnum.TASK_FAIL.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.TASK_FAIL;
                    break;
                }
            case "xuper":
                if(code.equalsIgnoreCase(XuperEnum.AssetGrantStatusEnum.GRANTING.getCode())||code.equalsIgnoreCase(XuperEnum.AssetGrantStatusEnum.TRANSFERING.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.PROCESSING;
                    break;
                }else if(code.equalsIgnoreCase(XuperEnum.AssetGrantStatusEnum.GRANT_SUCCESS.getCode())){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.TASK_SUCCESS;
                    break;
                }else if(code.equalsIgnoreCase(XuperEnum.AssetGrantStatusEnum.CANCELING.getCode())
                        ||code.equalsIgnoreCase(XuperEnum.AssetGrantStatusEnum.CANCELED.getCode())
                        ||code.equalsIgnoreCase(XuperEnum.AssetGrantStatusEnum.OTHER_ERROR.getCode())
                ){
                    taskStatusEnum = GalaxyEnum.TaskStatusEnum.TASK_FAIL;
                    break;
                }
        }
        return taskStatusEnum;
    }

    /**
     * 资产转让状态转换
     * @param routerType
     * @param code
     * @return
     */
    public static GalaxyEnum.NftTransferStatusEnum getTransStatusEnum(String routerType, String code){
        GalaxyEnum.NftTransferStatusEnum rsStatusEnum = null;
        switch (routerType){
            case "zxinchain":
                if(code.equalsIgnoreCase(ZxlnftEnum.TaskStatusEnum.PROCESSING.getCode())){
                    rsStatusEnum = GalaxyEnum.NftTransferStatusEnum.PROCESSING;
                    break;
                }else if(code.equalsIgnoreCase(ZxlnftEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                    rsStatusEnum = GalaxyEnum.NftTransferStatusEnum.SUCCESS;
                    break;
                }else if(code.equalsIgnoreCase(ZxlnftEnum.TaskStatusEnum.TASK_FAIL.getCode())){
                    rsStatusEnum = GalaxyEnum.NftTransferStatusEnum.FAIL;
                    break;
                }
            case "antchain":
                if(code.equalsIgnoreCase(AntchainEnum.TaskStatusEnum.PROCESSING.getCode())){
                    rsStatusEnum = GalaxyEnum.NftTransferStatusEnum.PROCESSING;
                    break;
                }else if(code.equalsIgnoreCase(AntchainEnum.TaskStatusEnum.TASK_SUCCESS.getCode())){
                    rsStatusEnum = GalaxyEnum.NftTransferStatusEnum.SUCCESS;
                    break;
                }else if(code.equalsIgnoreCase(AntchainEnum.TaskStatusEnum.TASK_FAIL.getCode())){
                    rsStatusEnum = GalaxyEnum.NftTransferStatusEnum.FAIL;
                    break;
                }
            case "xuper":
                if(code.equalsIgnoreCase(XuperEnum.AssetGrantStatusEnum.TRANSFERING.getCode())){
                    rsStatusEnum = GalaxyEnum.NftTransferStatusEnum.PROCESSING;
                    break;
                }else if(code.equalsIgnoreCase(XuperEnum.AssetGrantStatusEnum.GRANT_SUCCESS.getCode())){
                    rsStatusEnum = GalaxyEnum.NftTransferStatusEnum.SUCCESS;
                    break;
                }else if(code.equalsIgnoreCase(XuperEnum.AssetGrantStatusEnum.CANCELING.getCode())
                        ||code.equalsIgnoreCase(XuperEnum.AssetGrantStatusEnum.CANCELED.getCode())
                        ||code.equalsIgnoreCase(XuperEnum.AssetGrantStatusEnum.OTHER_ERROR.getCode())
                ){
                    rsStatusEnum = GalaxyEnum.NftTransferStatusEnum.FAIL;
                    break;
                }
        }
        return rsStatusEnum;
    }
}