package com.liquidnet.service.galaxy.router.strategy;

import com.liquidnet.service.galaxy.router.strategy.annotation.*;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyRouterStrategyListener
 * @Package com.liquidnet.service.galaxy.router.strategy
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/8 11:26
 */
@Component
public class GalaxyRouterStrategyListener  implements ApplicationListener<ContextRefreshedEvent> {
    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        //artwork
        GalaxyRouterStrategyContext strategyContext = event.getApplicationContext().getBean(GalaxyRouterStrategyContext.class);
        Map<String, Object> artworkBeans = event.getApplicationContext().getBeansWithAnnotation(StrategyGalaxyRouterArtworkHandler.class);
        artworkBeans.forEach((name, bean) -> {
            StrategyGalaxyRouterArtworkHandler typeHandler = bean.getClass().getAnnotation(StrategyGalaxyRouterArtworkHandler.class);
            strategyContext.putArtworkStrategy(typeHandler.value().getCode(), (IGalaxyRouterStrategyArtwork)bean);
        });

        //user
        Map<String, Object> userBeans = event.getApplicationContext().getBeansWithAnnotation(StrategyGalaxyRouterUserHandler.class);
        userBeans.forEach((name, bean) -> {
            StrategyGalaxyRouterUserHandler typeHandler = bean.getClass().getAnnotation(StrategyGalaxyRouterUserHandler.class);
            strategyContext.putUserStrategy(typeHandler.value().getCode(),(IGalaxyRouterStrategyUser)bean);
        });

        //publish
        Map<String, Object> publisBeans = event.getApplicationContext().getBeansWithAnnotation(StrategyGalaxyRouterPublishHandler.class);
        publisBeans.forEach((name, bean) -> {
            StrategyGalaxyRouterPublishHandler typeHandler = bean.getClass().getAnnotation(StrategyGalaxyRouterPublishHandler.class);
            strategyContext.putPublishStrategy(typeHandler.value().getCode(),(IGalaxyRouterStrategyPublish)bean);
        });

        //trade
        Map<String, Object> tradeBeans = event.getApplicationContext().getBeansWithAnnotation(StrategyGalaxyRouterTradeHandler.class);
        tradeBeans.forEach((name, bean) -> {
            StrategyGalaxyRouterTradeHandler typeHandler = bean.getClass().getAnnotation(StrategyGalaxyRouterTradeHandler.class);
            strategyContext.putTradeStrategy(typeHandler.value().getCode(),(IGalaxyRouterStrategyTrade)bean);
        });

        //tradeQuery
        Map<String, Object> tradeQueryBeans = event.getApplicationContext().getBeansWithAnnotation(StrategyGalaxyRouterTradeQueryHandler.class);
        tradeQueryBeans.forEach((name, bean) -> {
            StrategyGalaxyRouterTradeQueryHandler typeHandler = bean.getClass().getAnnotation(StrategyGalaxyRouterTradeQueryHandler.class);
            strategyContext.putTradeQueryStrategy(typeHandler.value().getCode(),(IGalaxyRouterStrategyTradeQuery)bean);
        });
    }
}
