package com.liquidnet.client.admin.zhengzai.candy.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyCouponAdminService;
import com.liquidnet.client.admin.zhengzai.candy.service.ICandyCouponRelateAdminService;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.candy.dto.CandyCouponRelateDto;
import com.liquidnet.service.candy.dto.admin.CandyMgtCouponRelateParam;
import com.liquidnet.service.candy.entity.CandyCoupon;
import com.liquidnet.service.candy.entity.CandyCouponRelate;
import com.liquidnet.service.candy.mapper.CandyCouponRelateMapper;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.entity.KylinRoadShows;
import com.liquidnet.service.kylin.mapper.KylinRoadShowsMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 券适用关联配置 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-19
 */
@Slf4j
@Service
public class CandyCouponRelateAdminServiceImpl extends ServiceImpl<CandyCouponRelateMapper, CandyCouponRelate> implements ICandyCouponRelateAdminService {
    @Autowired
    private CandyCouponRelateMapper candyCouponRelateMapper;
    @Autowired
    private KylinRoadShowsMapper kylinRoadShowsMapper;
    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;
    @Autowired
    private ICandyCouponAdminService candyCouponAdminService;

    @Override
    public AjaxResult relate(CandyMgtCouponRelateParam couponRelateParam) {
        String couponId = couponRelateParam.getCouponId(), redisKey, loginName = ShiroUtils.getLoginName();
        LambdaQueryWrapper<CandyCoupon> couponLambdaQueryWrapper = Wrappers.lambdaQuery();
        couponLambdaQueryWrapper.eq(CandyCoupon::getCouponId, couponId);
        couponLambdaQueryWrapper.eq(CandyCoupon::getState, 1);
        CandyCoupon coupon = candyCouponAdminService.getOne(couponLambdaQueryWrapper);
        if (null == coupon) return AjaxResult.warn("券不存在");
        if (coupon.getCouType() != 101) return AjaxResult.warn("当前操作只支持优先券类型");

        Integer scope = couponRelateParam.getScope();
        switch (scope) {
            case 1:
                redisKey = KylinRedisConst.COUPON_ROADSHOWS.concat(couponId);
                List<String> valList = (List<String>) redisDataSourceUtil.getRedisKylinUtil().get(redisKey);
                if (!CollectionUtils.isEmpty(valList)) {
                    LambdaQueryWrapper<KylinRoadShows> kylinRoadShowsLambdaQueryWrapper = Wrappers.lambdaQuery();
                    kylinRoadShowsLambdaQueryWrapper.in(KylinRoadShows::getRoadShowsId, valList);
                    kylinRoadShowsLambdaQueryWrapper.select(KylinRoadShows::getRoadShowsId, KylinRoadShows::getTitle);
                    List<KylinRoadShows> kylinRoadShowsList = kylinRoadShowsMapper.selectList(kylinRoadShowsLambdaQueryWrapper);
                    StringBuilder stringBuffer = new StringBuilder();
                    for (KylinRoadShows kylinRoadShows : kylinRoadShowsList) {
                        stringBuffer.append(kylinRoadShows.getTitle()).append(";");
                    }
                    return AjaxResult.warn(String.format("该券已关联巡演：%s", stringBuffer));
                }
                break;
            default:
                return AjaxResult.warn("适用范围无效");
        }

        LocalDateTime now = LocalDateTime.now();
        List<CandyCouponRelate> couponRelateList = new ArrayList<>();
        List<String> idList = couponRelateParam.getIdList();
        for (String id : idList) {
            CandyCouponRelate couponRelate = new CandyCouponRelate();
            couponRelate.setCouponId(couponId);
            couponRelate.setBusiId(id);
            couponRelate.setScope(scope);
            couponRelate.setState(1);
            couponRelate.setOperator(loginName);
            couponRelate.setCreatedAt(now);

            couponRelateList.add(couponRelate);
        }

        if (this.saveBatch(couponRelateList)) {
            switch (scope) {
                case 1:
                    redisDataSourceUtil.getRedisKylinUtil().set(redisKey, idList);
                    break;
            }
            return AjaxResult.success();
        }
        return AjaxResult.warn("操作失败");
    }

    @Override
    public Map<String, String> queryRelateRoadshowName(List<String> couponIdList) {
        try {
            List<CandyCouponRelateDto> list = candyCouponRelateMapper.selectMultiForRoadshowName(couponIdList);
            return list.stream().collect(Collectors.toMap(CandyCouponRelateDto::getCouponId, CandyCouponRelateDto::getBusiName));
        } catch (Exception e) {
            log.error("Ex.券关联巡演查询异常[couponIdList={}]", JsonUtils.toJson(couponIdList), e);
            return CollectionUtil.mapStringString();
        }
    }
}
