package com.liquidnet.common.third.zxlnft.dto.nft;

import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 11.下发查询用户信息验证码接
 * @class: UserQueryVerifyCodeReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:28
 */
@Data
public class Nft011UserQueryVerifyCodeReq implements Serializable {
    /**
     * 1企业 2个人
     */
    private int type;
    /**
     * 身份证号
     */
    private String cardNo;
    /**
     * 验证码场景：1查询用户信息 2NFT平台绑定地址
     */
    private int scene;

    private static final Nft011UserQueryVerifyCodeReq obj = new Nft011UserQueryVerifyCodeReq();
    private static final long serialVersionUID = -568800161549202593L;

    public static Nft011UserQueryVerifyCodeReq getNew() {
        try {
            return (Nft011UserQueryVerifyCodeReq) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft011UserQueryVerifyCodeReq();
        }
    }
}
