package com.liquidnet.common.third.zxlnft.dto.nft;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: SeriesReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:44
 */
@Data
public class Nft032SeriesResp implements Serializable {
    private SeriesInfo seriesInfo;

    @Data
    public class SeriesInfo{
        /**
         * 系列ID
         */
        private String seriesId;
        /**
         * 系列名字
         */
        private String name;
        /**
         * 创建者地址
         */
        private String creatorAddr;
        /**
         * 总数
         */
        private Long totalCount;
        /**
         * 系列下的nftId后缀,是否从0开始，true就是从0开始，默认为false，从1开始
         */
        private boolean seriesBeginFromZero;
        /**
         * 当前个数（当前已发行此系列的个数）
         */
        private Long crtCount;
        /**
         * 封面图
         */
        private String coverUrl;
        /**
         * 描述
         */
        private String desc;
        /**
         * 创建时间戳
         */
        private Long createTimeStamp;

        public String getSeriesId() {
            return seriesId;
        }

        public void setSeriesId(String seriesId) {
            this.seriesId = seriesId;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCreatorAddr() {
            return creatorAddr;
        }

        public void setCreatorAddr(String creatorAddr) {
            this.creatorAddr = creatorAddr;
        }

        public Long getTotalCount() {
            return totalCount;
        }

        public void setTotalCount(Long totalCount) {
            this.totalCount = totalCount;
        }

        public boolean isSeriesBeginFromZero() {
            return seriesBeginFromZero;
        }

        public void setSeriesBeginFromZero(boolean seriesBeginFromZero) {
            this.seriesBeginFromZero = seriesBeginFromZero;
        }

        public Long getCrtCount() {
            return crtCount;
        }

        public void setCrtCount(Long crtCount) {
            this.crtCount = crtCount;
        }

        public String getCoverUrl() {
            return coverUrl;
        }

        public void setCoverUrl(String coverUrl) {
            this.coverUrl = coverUrl;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public Long getCreateTimeStamp() {
            return createTimeStamp;
        }

        public void setCreateTimeStamp(Long createTimeStamp) {
            this.createTimeStamp = createTimeStamp;
        }
    }

    private static final Nft032SeriesResp obj = new Nft032SeriesResp();
    public static Nft032SeriesResp getNew() {
        try {
            return (Nft032SeriesResp) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft032SeriesResp();
        }
    }

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }
}
