package com.liquidnet.service.candy.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

import com.liquidnet.service.candy.dto.CandyCouponCodeDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 用户券信息
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CandyUserCoupon implements Serializable,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String ucouponId;

    /**
     * ~candy_mgt_coupon.mcoupon_id
     */
    private String mcouponId;

    /**
     * ~adam_user.uid
     */
    private String uid;

    /**
     * ~candy_coupon.coupon_id
     */
    private String couponId;

    /**
     * 专享标识[0-常规｜1-会员专属]
     * <p>
     * 变更前：`candy_coupon.exclusive`用于根据会员有效期设置券有效期及标识用户端券分类（普通券、会员券等）；
     * 变更后：
     * 原`candy_coupon.exclusive`废除
     * 实际发放逻辑中，原标识"是否根据会员有效期设置券有效期"的`candy_coupon.exclusive`字段改为`candy_mgt_coupon.exclusively`
     * 在`candy_user_coupon`及`candy_common_coupon`中添加`exclusive`字段，发放时直接由`candy_mgt_coupon.exclusively`赋值该属性
     * </p>
     */
    private Integer exclusive;

    /**
     * 用户券状态[1-可用|2-无效|3-已过期|5-已使用|9-移除不展示（过期或已使用）]
     */
    private Integer state;

    /**
     * 兑换码
     */
    private String ccode;

    /**
     * 激活时间
     */
    private LocalDateTime bindAt;

    /**
     * 到期时间
     */
    private LocalDateTime duedAt;

    /**
     * 使用时间
     */
    private LocalDateTime usedAt;

    /**
     * 用于记录购买的内容
     */
    private String usedFor;

    /**
     * 操作人
     */
    private String operator;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


    private static final CandyUserCoupon obj = new CandyUserCoupon();

    public static CandyUserCoupon getNew() {
        try {
            return (CandyUserCoupon) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new CandyUserCoupon();
        }
    }
}
