package com.liquidnet.service.goblin.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 商品明细数据：
 * <p>
 * SELECT
 * c.name AS '活动名称',
 * c.store_name AS '店铺名称',
 * # DATE_FORMAT(c.created_at,'%Y-%m-%d') as 日期,
 * spu_no AS '商品编号' ,
 * b.sku_bar_code AS '商品条码' ,
 * a.`name` AS '商品名称' ,
 * b.`name` AS '款式名称' ,
 * gg.cate1_name AS '一级分类' ,
 * gg.cate2_name AS '二级分类' ,
 * gg.cate3_name AS '三级分类' ,
 * b.price AS '款式价格' ,
 * sum(CASE WHEN c. STATUS not IN(0 , 5) THEN c.num ELSE 0 END) AS '销售数量' ,
 * sum(case when c.status in (6,7) then c.num else 0 end) '退款数量',
 * sum(CASE WHEN c. STATUS not  IN(0 , 5) THEN c.sku_price_actual ELSE 0 END ) AS '销售金额' ,
 * sum(CASE WHEN c. STATUS IN(6 , 7) THEN c.sku_price_actual ELSE 0 END) AS '退款金额' ,
 * sum(CASE WHEN c. STATUS IN(2 , 3 , 4) THEN c.price_voucher ELSE 0 END ) AS '优惠金额',
 * sum(CASE WHEN c. STATUS IN(2 , 3 , 4) THEN c.num ELSE 0 END ) AS '小计数量' ,
 * sum(CASE WHEN c. STATUS IN(2 , 3 , 4) THEN c.sku_price_actual ELSE 0 END) AS '小计金额'
 * FROM
 * goblin_goods AS a
 * INNER JOIN goblin_goods_sku AS b ON a.spu_id = b.spu_id
 * LEFT JOIN(
 * SELECT
 * c.sku_id ,
 * d.market_id ,
 * c. STATUS ,
 * c.num ,
 * c.sku_price_actual ,
 * c.price_voucher,
 * c.created_at,
 * gsi.store_name,
 * gsm.name
 * FROM
 * goblin_order_sku AS c
 * INNER JOIN goblin_store_order AS d ON d.order_id = c.order_id
 * inner join goblin_store_info gsi on gsi.store_id = d.store_id
 * inner join goblin_self_marketing gsm on gsm.self_market_id = SUBSTRING_INDEX(d.market_id, 'ZZ', -1)
 * ) AS c ON SUBSTRING_INDEX(c.sku_id, 'ZZ', 1)  = b.sku_id
 * INNER JOIN(
 * SELECT
 * spu_id ,
 * gg. NAME ,
 * gsgc1. NAME AS cate1_name ,
 * gsgc2. NAME AS cate2_name,
 * gsgc3. NAME AS cate3_name
 * FROM
 * goblin_goods AS gg
 * LEFT JOIN goblin_self_goods_category AS gsgc1 ON gsgc1.cate_id = gg.cate_fid
 * LEFT JOIN goblin_self_goods_category AS gsgc2 ON gsgc2.cate_id = gg.cate_sid
 * LEFT JOIN goblin_self_goods_category AS gsgc3 ON gsgc3.cate_id = gg.cate_tid
 * ) AS gg ON a.spu_id = gg.spu_id
 * where c.market_id = 'ZZ222981107161997155345' and a.store_id = '1314c10a2b400c355dde0d060ba83afe'
 * # where c.market_id = 'ZZ223161701266386447667' and a.store_id = '3a8440d3f0aa49a084ff3cf0310ebae2'
 * # and c.created_at >='2022-11-18' and c.created_at <'2022-11-21'
 * GROUP BY
 * #  日期,
 * b.sku_id;
 */
@Getter
@Setter
public class GoblinMarketGoodsUnDateExcelDto implements Serializable, Cloneable {
    private static final long serialVersionUID = -2804101458736599181L;
    @ExcelProperty("活动名称")
    private String marketName;
    @ExcelProperty("店铺名称")
    private String storeName;
    @ExcelProperty("商品编号")
    private String spuNo;
    @ExcelProperty("商品条码")
    private String sku_bar_code;
    @ExcelProperty("商品名称")
    private String spuName;
    @ExcelProperty("款式名称")
    private String skuName;
    @ExcelProperty("一级分类")
    private String gg1;
    @ExcelProperty("二级分类")
    private String gg2;
    @ExcelProperty("三级分类")
    private String gg3;
    @ExcelProperty("款式价格")
    private BigDecimal skuPrice;
    @ExcelProperty("销售数量")
    private int saleCount;
    @ExcelProperty("退款数量")
    private int refundCount;
    @ExcelProperty("销售金额")
    private BigDecimal salePrice;
    @ExcelProperty("退款金额")
    private BigDecimal refundPrice;
    @ExcelProperty("优惠金额")
    private BigDecimal voucherPrice;
    @ExcelProperty("小计数量")
    private int count;
    @ExcelProperty("小计金额")
    private BigDecimal price;

}
