package com.liquidnet.service.kylin.dao;

import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Data
public class PerformancePartnerListDao implements Cloneable {

    //演出数据
    private String performancesId;
    private String title;
    private String timeStart;
    private String timeEnd;
    private Integer totalGeneral;
    private Integer saleGeneral;
    private Integer number;
    private Integer refundNumber;
    private BigDecimal priceActual;
    private BigDecimal priceRefund;
    private BigDecimal totalSalePrice;
    private Integer surplusGeneral;
    private Integer status;
    private Integer type;
    private String timeSell;
    private String timeStop;
    private Integer payCountdownMinute;
    private Integer auditStatus;
    private Integer fieldAuditStatus;
    private List<String> permissionId;
    private String rejectTxt;
    private String createdAt;

    private static final PerformancePartnerListDao obj = new PerformancePartnerListDao();
    public static PerformancePartnerListDao getNew() {
        try {
            return (PerformancePartnerListDao) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new PerformancePartnerListDao();
        }
    }
}
