package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 订单退款入场人表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinOrderRefundEntities implements Serializable  ,Cloneable{

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    private String orderRefundsEntitiesId;

    private String orderRefundsId;

    private String orderTicketEntitiesId;

    private BigDecimal refundPrice;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private static final KylinOrderRefundEntities obj = new KylinOrderRefundEntities();
    public static KylinOrderRefundEntities getNew() {
        try {
            return (KylinOrderRefundEntities) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinOrderRefundEntities();
        }
    }
}
