package com.liquidnet.service.sweet.service.impl;

import com.alipay.api.AlipayClient;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketTimesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.sweet.config.PayAlipayUtils;
import com.liquidnet.service.sweet.entity.SweetRemind;
import com.liquidnet.service.sweet.vo.SweetWechatUsersVo;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zjp
 * @create 2024-04-25 15:47
 */
@Slf4j
@Service
public class SweetAppletServiceImpl {

    public ResponseDto findCode2openid(String code,String type) {
        AlipayClient httpClientApplet = PayAlipayUtils.getInstance().getHttpClientApplet();
        // 构造请求参数以调用接口
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        // 设置授权码
        request.setCode(code);
        // 设置授权方式
        request.setGrantType("authorization_code");
        try {
            AlipaySystemOauthTokenResponse response = httpClientApplet.execute(request);
            log.info("获取支付宝用户信息response=={}", response.getBody());
            System.out.println(response.getBody());
            if (response.isSuccess()) {
                return ResponseDto.success(response.getOpenId());
            } else {
                return ResponseDto.failure("获取支付宝用户信息失败!");
            }
        } catch (Exception e) {
            log.error("获取支付宝用户信息失败exception={}", e);
            return ResponseDto.failure("获取支付宝用户信息失败!");
        }
    }
}
