package com.liquidnet.service.galaxy.router.zxin.biz;

import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.dto.Nft016IdentityBindQueryReqDto;
import com.liquidnet.common.third.zxlnft.dto.Nft016IdentityBindQueryRespDto;
import com.liquidnet.common.third.zxlnft.dto.ZxlnftResponseDto;
import com.liquidnet.common.third.zxlnft.dto.nft.Nft016QueryRsData;
import com.liquidnet.common.third.zxlnft.util.ZxlWalletSdkUtil;
import com.liquidnet.common.third.zxlnft.util.ZxlnftSdkUtil;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.biz.GalaxyEnumBiz;
import com.liquidnet.service.galaxy.constant.GalaxyErrorEnum;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserBindStatusQueryReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserBindStatusQueryRespDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyUserRegisterRespDto;
import com.liquidnet.service.galaxy.utils.GalaxyDataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxinUserBiz
 * @Package com.liquidnet.service.galaxy.router.zxin.biz
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/15 13:05
 */
@Slf4j
@Component
public class ZxinUserBiz {
    @Autowired
    private ZxlnftSdkUtil zxlnftSdkUtil;

    @Autowired
    private ZxlWalletSdkUtil zxlWalletSdkUtil;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    @Autowired
    private GalaxyDataUtils dataUtils;

    @Autowired
    private ZxinUserCommonBiz zxinUserCommonBiz;

    public ResponseDto<GalaxyUserRegisterRespDto> userRegister(GalaxyUserRegisterReqDto reqDto) {
        return zxinUserCommonBiz.userRegister(reqDto);
    }

    public ResponseDto<GalaxyUserBindStatusQueryRespDto> userBindStatusQuery(GalaxyUserBindStatusQueryReqDto reqDto){
        //获取用户信息
        GalaxyUserInfoBo userInfoBo = dataUtils.getGalaxyUserInfo(reqDto.getRouterType(),reqDto.getUserId());
        if(StringUtil.isNull(userInfoBo)){
            log.error("开始执行nftPublishAndBuy error msg:{}", GalaxyErrorEnum.NFT_BUY_FAIL_USER_NOT_EXIST.getMessage());
            return ResponseDto.failure(GalaxyErrorEnum.NFT_BUY_FAIL_USER_NOT_EXIST.getCode(), GalaxyErrorEnum.NFT_BUY_FAIL_USER_NOT_EXIST.getMessage());
        }

        Nft016IdentityBindQueryReqDto nft016ReqDto = Nft016IdentityBindQueryReqDto.getNew();
        nft016ReqDto.setAddressList(userInfoBo.getBlockChainAddress());
        ZxlnftResponseDto<Nft016IdentityBindQueryRespDto> zxlnftResponseDto = zxlnftSdkUtil.nft016IdentityBindQuery(nft016ReqDto);

        GalaxyUserBindStatusQueryRespDto userBindStatusQueryRespDto = GalaxyUserBindStatusQueryRespDto.getNew();
        if(zxlnftResponseDto.isSuccess()){
            Nft016QueryRsData nft016QueryRsData = zxlnftResponseDto.getData().getList().get(0);
            userBindStatusQueryRespDto.setBlockChainAddress(nft016QueryRsData.getAddress());
            Integer userBindStatus = Integer.valueOf(GalaxyEnumBiz.getUserBindStatusEnum(reqDto.getRouterType(),nft016QueryRsData.getStatus()).getCode());
            userBindStatusQueryRespDto.setUserBindStatus(userBindStatus);
        }else{
            return ResponseDto.failure();
        }
        return ResponseDto.success(userBindStatusQueryRespDto);
    }
}
