package com.liquidnet.client.admin.web.controller.zhengzai.slime;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeCompaniesAdminService;
import com.liquidnet.client.admin.zhengzai.slime.service.ISlimeFieldsAdminService;
import com.liquidnet.service.slime.dto.param.admin.SlimeFieldEditParam;
import com.liquidnet.service.slime.dto.param.admin.SlimeFieldListParam;
import com.liquidnet.service.slime.dto.vo.SlimeCompaniesVo;
import com.liquidnet.service.slime.dto.vo.SlimeFieldsVo;
import com.liquidnet.service.slime.entity.SlimeCompanies;
import com.liquidnet.service.slime.entity.SlimeFields;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Api(tags = "场地管理")
@Controller
@RequestMapping("slime/field")
public class SlimeFieldsController extends BaseController {

    private final String prefix = "zhengzai/kylin/field";

    @Autowired
    ISlimeFieldsAdminService slimeFieldsAdminService;

    @Autowired
    ISlimeCompaniesAdminService slimeCompaniesAdminService;


    @GetMapping()
    public String list() {
        return prefix + "/list";
    }


    @Log(title = "场地列表", businessType = BusinessType.LIST)
    @RequiresPermissions("slime:field")
    @PostMapping("/list")
    @ResponseBody
    public TableDataInfo list(SlimeFieldListParam param) {
        startPage();
        return getDataTable(slimeFieldsAdminService.list(
                Wrappers.lambdaQuery(SlimeFields.class)
                        .eq(param.getFieldId().length() > 0, SlimeFields::getFieldId, param.getFieldId())
                        .eq(param.getIsOnline() >= 0, SlimeFields::getIsOnline, param.getIsOnline())
                        .eq(param.getClaimStatus() >= 0, SlimeFields::getClaimStatus, param.getClaimStatus())
                        .select(
                                SlimeFields::getFieldId, SlimeFields::getIsOnline, SlimeFields::getClaimStatus, SlimeFields::getUid,
                                SlimeFields::getName, SlimeFields::getLogo,
                                SlimeFields::getCreatedAt
                        )
        ));
    }

    @Log(title = "场地详情", businessType = BusinessType.DETAIL)
    @RequiresPermissions("slime:field")
    @GetMapping("/details/{fieldId}")
    public String detail(@PathVariable("fieldId") String fieldId, ModelMap mmap) {

        LambdaQueryWrapper<SlimeFields> fieldsLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeFields.class);
        fieldsLambdaQueryWrapper.eq(SlimeFields::getFieldId, fieldId);
        SlimeFields fields = slimeFieldsAdminService.getOne(fieldsLambdaQueryWrapper);

        SlimeFieldsVo fieldsVo = SlimeFieldsVo.getNew();
        fieldsVo.copy(fields);
        if (null != fieldsVo.getCompanyId() && !fieldsVo.getCompanyId().isEmpty()) {
            LambdaQueryWrapper<SlimeCompanies> companiesLambdaQueryWrapper = Wrappers.lambdaQuery(SlimeCompanies.class);
            companiesLambdaQueryWrapper.eq(SlimeCompanies::getCompanyId, fieldsVo.getCompanyId());
            SlimeCompanies companies = slimeCompaniesAdminService.getOne(companiesLambdaQueryWrapper);

            SlimeCompaniesVo companiesVo = SlimeCompaniesVo.getNew();
            companiesVo.copy(companies);
            fieldsVo.setCompaniesVo(companiesVo);
        }

        mmap.put("fieldInfo", fieldsVo);

        return prefix + "/detail";
    }

    @ApiOperation(value = "场地编辑")
    @Log(title = "场地编辑", businessType = BusinessType.UPDATE)
    @RequiresPermissions("slime:field")
    @PostMapping("edit")
    @ResponseBody
    public AjaxResult edit(@RequestBody @Validated SlimeFieldEditParam parameter) {
        return toAjax(slimeFieldsAdminService.fieldEdit(parameter));
    }
}
