package com.liquidnet.service.sweet.controller;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetPerformanceShow;
import com.liquidnet.service.sweet.service.ISweetPerformanceAppService;
import com.liquidnet.service.sweet.vo.SweetPerformanceShowVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "演出AR")
@RestController
@RequestMapping("/sweet-App")
public class SweetPerformanceAppController {
    @Autowired
    private ISweetPerformanceAppService sweetPerformanceAppService;

    @GetMapping("listInTime")
    @ApiOperation("ar列表-移动端")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "page", value = "页数", required = true),
            @ApiImplicitParam(type = "query", dataType = "Integer", name = "size", value = "数量", required = true),
    })
    public ResponseDto<PageInfo<SweetPerformanceShowVo>> getlistInTime(@RequestParam() Integer page,
                                                                       @RequestParam() Integer size) {
        return sweetPerformanceAppService.getlistInTime(page, size);
    }

}
