package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 购票须知表
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinBuyNotice implements Serializable ,Cloneable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Integer mid;

    /**
     * buy_notice_id
     */
    private String buyNoticeId;

    /**
     * 标题
     */
    private String title;

    /**
     * 图片地址
     */
    private String imgUrl;

    /**
     * 内容
     */
    private String message;

    /**
     * 状态 1可用 0弃用
     */
    private Integer status;

    /**
     * 排序 大在上
     */
    private Integer sort;

    /**
     * 须知类型 1购票须知 2观演须知
     */
    private Integer noticeType;

    /**
     * 须知类型名称（非数据库字段）
     */
    @TableField(exist = false)
    private String noticeTypeName;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;

    private static final KylinBuyNotice obj = new KylinBuyNotice();
    public static KylinBuyNotice getNew() {
        try {
            return (KylinBuyNotice) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinBuyNotice();
        }
    }

}
