package com.liquidnet.service.sweet.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;

/**
 * 失物招领管理员返回VO
 *
 * @author liquidnet
 * @since 2025-01-18
 */
@ApiModel("失物招领管理员返回")
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetLostFoundAdminVo implements Serializable, Cloneable {

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("备注姓名")
    private String name;

    @ApiModelProperty("权限类型：1-发帖员 2-管理员")
    private Integer permissionType;

    @ApiModelProperty("授权范围：1-本站次 2-全站")
    private Integer authScope;

    @ApiModelProperty("演出ID")
    private String performanceId;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

}